/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.service.paymenttype.impl;

import com.digiwin.dap.middleware.cac.constant.CacConstants;
import com.digiwin.dap.middleware.cac.domain.AuthorizationModuleVO;
import com.digiwin.dap.middleware.cac.domain.AuthorizationVO;
import com.digiwin.dap.middleware.cac.domain.CalcExpire;
import com.digiwin.dap.middleware.cac.domain.CloudPurchaseDTO;
import com.digiwin.dap.middleware.cac.domain.EditParamVO;
import com.digiwin.dap.middleware.cac.domain.EnabledModuleDTO;
import com.digiwin.dap.middleware.cac.domain.EnvProperties;
import com.digiwin.dap.middleware.cac.domain.ObsoleteTenantAuthInfo;
import com.digiwin.dap.middleware.cac.domain.PurchaseVO;
import com.digiwin.dap.middleware.cac.domain.UsageCountResultVO;
import com.digiwin.dap.middleware.cac.domain.enumeration.CountPattern;
import com.digiwin.dap.middleware.cac.domain.enumeration.PaymentType;
import com.digiwin.dap.middleware.cac.service.paymenttype.CalcUtil;
import com.digiwin.dap.middleware.cac.service.paymenttype.PaymentTypeService;
import com.digiwin.dap.middleware.cac.service.paymenttype.impl.AbstractPaymentTypeService;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PaymentTypeMonthServiceImpl
extends AbstractPaymentTypeService
implements PaymentTypeService {
    @Autowired
    private EnvProperties envProperties;

    public boolean support(int paymentType) {
        return PaymentType.Month.ordinal() == paymentType;
    }

    public void decidePaymentType(CloudPurchaseDTO entityPurchase, PurchaseVO domainPurchase) {
        entityPurchase.setCountType(CountPattern.Unlimited.name());
        entityPurchase.setTotalUsage(-1);
        entityPurchase.setRemainingUsage(-1);
        entityPurchase.setTotalCount(-1);
        if (Objects.equals(0, this.envProperties.getCloud())) {
            this.cloudDecidePaymentType(entityPurchase, domainPurchase);
        } else {
            this.groundDecidePaymentType(entityPurchase, domainPurchase);
        }
    }

    public void decideUpdatePaymentType(CloudPurchaseDTO entityPurchase, PurchaseVO domainPurchase) {
        entityPurchase.setTotalCount(-1);
        entityPurchase.setStrategyId(domainPurchase.getSellingStrategy().getId());
        CalcExpire calcExpire = CalcExpire.get((PurchaseVO)domainPurchase, (LocalDateTime)entityPurchase.getExpiredDateTime());
        entityPurchase.setExpiredDateTime(CalcUtil.calcUpdatePurchaseExpiredTime((CalcExpire)calcExpire));
        domainPurchase.getSellingStrategy().getEnabledModules().forEach(domainModule -> {
            EnabledModuleDTO entityModule = entityPurchase.getModules().stream().filter(m -> m.getId().equals(domainModule.getId())).findFirst().orElse(null);
            calcExpire.module(entityModule, domainModule);
            LocalDateTime moduleExpiredTime = CalcUtil.calcUpdateModuleExpiredTime((CalcExpire)calcExpire);
            if (entityModule == null) {
                entityPurchase.getModules().add(new EnabledModuleDTO(domainModule.getId(), domainModule.getName(), -1, -1, LocalDateTime.now(), moduleExpiredTime, domainModule));
            } else {
                entityModule.setName(domainModule.getName());
                entityModule.setExpiredTime(moduleExpiredTime);
                entityModule.setActions(domainModule.updateActionString(entityModule));
            }
            if (moduleExpiredTime.isAfter(entityPurchase.getExpiredDateTime())) {
                entityPurchase.setExpiredDateTime(moduleExpiredTime);
            }
        });
    }

    public void decideUpdatePaymentType(CloudPurchaseDTO purchase, List<AuthorizationModuleVO> modules) {
        this.processAddModuleOrAction(purchase, modules);
    }

    public EnabledModuleDTO getNewModule(CloudPurchaseDTO purchase, AuthorizationModuleVO module) {
        return new EnabledModuleDTO(module.getId(), module.getName(), -1, -1, LocalDateTime.now(), purchase.getExpiredDateTime(), module);
    }

    public void decideUpdatePaymentType(CloudPurchaseDTO purchase, EditParamVO editParamVO) {
        purchase.setTotalCount(-1);
        purchase.setEffectiveDateTime(editParamVO.getEffectiveTime());
        purchase.setExpiredDateTime(editParamVO.getExpiredTime().with(LocalTime.MAX).withNano(0));
        if (editParamVO.getModules() != null) {
            editParamVO.getModules().forEach(module -> {
                EnabledModuleDTO target = purchase.getModules().stream().filter(m -> m.getId().equals(module.getId())).findFirst().orElse(null);
                if (target != null) {
                    target.setEffectiveTime(editParamVO.getEffectiveTime());
                    target.setExpiredTime(module.getExpiredTime().with(LocalTime.MAX).withNano(0));
                    target.setActions(module.updateActionString(target));
                    if (module.getExpiredTime().with(LocalTime.MAX).withNano(0).isAfter(editParamVO.getExpiredTime().with(LocalTime.MAX).withNano(0))) {
                        purchase.setExpiredDateTime(module.getExpiredTime().with(LocalTime.MAX).withNano(0));
                    }
                } else {
                    purchase.getModules().add(new EnabledModuleDTO(module.getId(), module.getName(), -1, -1, editParamVO.getEffectiveTime(), module.getExpiredTime(), module));
                }
            });
        }
    }

    public Boolean checkAuthorizationValid(CloudPurchaseDTO purchase) {
        return LocalDateTime.now().isAfter(purchase.getEffectiveDateTime()) && LocalDateTime.now().isBefore(purchase.getExpiredDateTime());
    }

    public Boolean checkModuleInvalid(int paymentType, EnabledModuleDTO module) {
        return LocalDateTime.now().isBefore(module.getExpiredTime());
    }

    public UsageCountResultVO getAuthorizationCountingResult(AuthorizationVO authorizationVO, AuthorizationModuleVO module) {
        return new UsageCountResultVO(LocalDateTime.now().isBefore(module.getExpiredTime()), -1, -1);
    }

    private void groundDecidePaymentType(CloudPurchaseDTO purchase, PurchaseVO info) {
        if (info.getExpiredTime() == null) {
            purchase.setExpiredDateTime(CacConstants.PERMANENT_TIME);
            purchase.getModules().forEach(module -> module.setExpiredTime(CacConstants.PERMANENT_TIME));
        } else {
            purchase.setExpiredDateTime(info.getExpiredTime());
            purchase.getModules().forEach(module -> {
                module.setTotalUsage(-1);
                module.setRemainingUsage(-1);
                module.setExpiredTime(info.getExpiredTime());
            });
        }
    }

    private void cloudDecidePaymentType(CloudPurchaseDTO entityPurchase, PurchaseVO domainPurchase) {
        CalcExpire calcExpire = CalcExpire.get((PurchaseVO)domainPurchase);
        entityPurchase.setExpiredDateTime(CalcUtil.calcNewPurchaseExpiredTime((CalcExpire)calcExpire));
        entityPurchase.getModules().forEach(module -> {
            module.setTotalUsage(-1);
            module.setRemainingUsage(-1);
            module.setEffectiveTime(calcExpire.getEffectiveDateTime());
            calcExpire.module(module.getExpiredTime());
            module.setExpiredTime(CalcUtil.calcNewModuleExpiredTime((CalcExpire)calcExpire));
        });
    }

    public Boolean checkObsoleteAuthEnable(CloudPurchaseDTO authInfo, ObsoleteTenantAuthInfo updateAuthInfo) {
        if (null != updateAuthInfo.getOldExpiredDateTime() && null != updateAuthInfo.getOldTotalUsageBound()) {
            boolean expireDate = updateAuthInfo.getPlatform() != false ? updateAuthInfo.getOldExpiredDateTime().isBefore(authInfo.getExpiredDateTime()) : !updateAuthInfo.getExpiredDateTime().equals(authInfo.getExpiredDateTime());
            return expireDate;
        }
        boolean expireDate = updateAuthInfo.getExpiredDateTime().isBefore(authInfo.getExpiredDateTime());
        return expireDate;
    }
}

