/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.service.paymenttype.impl;

import com.digiwin.dap.middleware.cac.constant.CacConstants;
import com.digiwin.dap.middleware.cac.domain.AuthorizationModuleVO;
import com.digiwin.dap.middleware.cac.domain.AuthorizationVO;
import com.digiwin.dap.middleware.cac.domain.CloudPurchaseDTO;
import com.digiwin.dap.middleware.cac.domain.EditParamVO;
import com.digiwin.dap.middleware.cac.domain.EnabledModuleDTO;
import com.digiwin.dap.middleware.cac.domain.ObsoleteTenantAuthInfo;
import com.digiwin.dap.middleware.cac.domain.PurchaseVO;
import com.digiwin.dap.middleware.cac.domain.UsageCountResultVO;
import com.digiwin.dap.middleware.cac.domain.enumeration.CountPattern;
import com.digiwin.dap.middleware.cac.domain.enumeration.PaymentType;
import com.digiwin.dap.middleware.cac.domain.enumeration.ProductType;
import com.digiwin.dap.middleware.cac.entity.PurchaseCount;
import com.digiwin.dap.middleware.cac.service.basic.PurchaseCountCrudService;
import com.digiwin.dap.middleware.cac.service.paymenttype.PaymentTypeService;
import com.digiwin.dap.middleware.cac.service.paymenttype.impl.AbstractPaymentTypeService;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PaymentTypeNoControlServiceImpl
extends AbstractPaymentTypeService
implements PaymentTypeService {
    @Autowired
    private PurchaseCountCrudService purchaseCountCrudService;

    public boolean support(int paymentType) {
        return PaymentType.NoControl.ordinal() == paymentType;
    }

    public void decidePaymentType(CloudPurchaseDTO entityPurchase, PurchaseVO domainPurchase) {
        entityPurchase.setCountType(CountPattern.Unlimited.name());
        entityPurchase.setTotalCount(-1);
        if (ProductType.app.name().equals(entityPurchase.getProductType())) {
            entityPurchase.setExpiredDateTime(CacConstants.PERMANENT_TIME);
        } else {
            LocalDateTime now = LocalDateTime.now();
            entityPurchase.setExpiredDateTime(now.plusMonths(12L).with(LocalTime.MAX).withNano(0));
        }
        entityPurchase.getModules().forEach(module -> {
            module.setTotalUsage(-1);
            module.setRemainingUsage(-1);
            module.setEffectiveTime(entityPurchase.getEffectiveDateTime());
            module.setExpiredTime(CacConstants.PERMANENT_TIME);
        });
    }

    public void decideUpdatePaymentType(CloudPurchaseDTO entityPurchase, PurchaseVO domainPurchase) {
        entityPurchase.setStrategyId(domainPurchase.getSellingStrategy().getId());
        domainPurchase.getSellingStrategy().getEnabledModules().forEach(module -> {
            EnabledModuleDTO target = entityPurchase.getModules().stream().filter(m -> m.getId().equals(module.getId())).findFirst().orElse(null);
            if (target == null) {
                entityPurchase.getModules().add(new EnabledModuleDTO(module.getId(), module.getName(), -1, -1, LocalDateTime.now(), CacConstants.PERMANENT_TIME, module));
            } else {
                target.setName(module.getName());
                target.setActions(module.updateActionString(target));
            }
        });
    }

    public void decideUpdatePaymentType(CloudPurchaseDTO purchase, EditParamVO editParamVO) {
        editParamVO.getModules().forEach(module -> {
            EnabledModuleDTO target = purchase.getModules().stream().filter(m -> m.getId().equals(module.getId())).findFirst().orElse(null);
            if (target == null) {
                purchase.getModules().add(new EnabledModuleDTO(module.getId(), module.getName(), -1, -1, editParamVO.getEffectiveTime(), CacConstants.PERMANENT_TIME, module));
            } else {
                target.setActions(module.updateActionString(target));
            }
        });
        purchase.setExpiredDateTime(CacConstants.PERMANENT_TIME);
    }

    public void decideUpdatePaymentType(CloudPurchaseDTO purchase, List<AuthorizationModuleVO> modules) {
        this.processAddModuleOrAction(purchase, modules);
    }

    public EnabledModuleDTO getNewModule(CloudPurchaseDTO purchase, AuthorizationModuleVO module) {
        return new EnabledModuleDTO(module.getId(), module.getName(), -1, -1, LocalDateTime.now(), CacConstants.PERMANENT_TIME, module);
    }

    public Boolean checkAuthorizationValid(CloudPurchaseDTO purchase) {
        return true;
    }

    public Boolean checkModuleInvalid(int paymentType, EnabledModuleDTO module) {
        return true;
    }

    public UsageCountResultVO getAuthorizationCountingResult(AuthorizationVO authorizationVO, AuthorizationModuleVO module) {
        return new UsageCountResultVO(true, -1, -1);
    }

    public UsageCountResultVO decrementUsageCount(LocalDateTime expiredDateTime, PurchaseCount purchaseCount, Integer decreaseCount) {
        return new UsageCountResultVO(true, purchaseCount.getRemainUsageBound(), purchaseCount.getTotalUsageBound());
    }

    public UsageCountResultVO addUsageCount(LocalDateTime expiredDateTime, PurchaseCount purchaseCount, Integer decreaseCount) {
        if (Objects.isNull(decreaseCount)) {
            decreaseCount = 1;
        }
        if (purchaseCount.getRemainUsageBound() + decreaseCount <= purchaseCount.getTotalUsageBound() && LocalDateTime.now().isBefore(expiredDateTime)) {
            purchaseCount.setRemainUsageBound(purchaseCount.getRemainUsageBound() + decreaseCount);
            this.purchaseCountCrudService.updateByPurchaseId(purchaseCount);
            return new UsageCountResultVO(true, purchaseCount.getRemainUsageBound(), purchaseCount.getTotalUsageBound());
        }
        return new UsageCountResultVO(false, purchaseCount.getRemainUsageBound(), purchaseCount.getTotalUsageBound());
    }

    public Boolean checkObsoleteAuthEnable(CloudPurchaseDTO authInfo, ObsoleteTenantAuthInfo updateAuthInfo) {
        if (null != updateAuthInfo.getOldExpiredDateTime() && null != updateAuthInfo.getOldTotalUsageBound()) {
            boolean expireDate = updateAuthInfo.getPlatform() != false ? updateAuthInfo.getOldExpiredDateTime().isBefore(authInfo.getExpiredDateTime()) : !updateAuthInfo.getExpiredDateTime().equals(authInfo.getExpiredDateTime());
            return expireDate;
        }
        boolean expireDate = updateAuthInfo.getExpiredDateTime().isBefore(authInfo.getExpiredDateTime());
        return expireDate;
    }
}

