/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.service.paymenttype.impl;

import com.digiwin.dap.middleware.cac.constant.CacConstants;
import com.digiwin.dap.middleware.cac.constant.I18nError;
import com.digiwin.dap.middleware.cac.domain.AuthorizationModuleVO;
import com.digiwin.dap.middleware.cac.domain.AuthorizationVO;
import com.digiwin.dap.middleware.cac.domain.CalcExpire;
import com.digiwin.dap.middleware.cac.domain.CancelAuth;
import com.digiwin.dap.middleware.cac.domain.CloudPurchaseDTO;
import com.digiwin.dap.middleware.cac.domain.EditParamVO;
import com.digiwin.dap.middleware.cac.domain.EnabledModuleDTO;
import com.digiwin.dap.middleware.cac.domain.EnvProperties;
import com.digiwin.dap.middleware.cac.domain.ObsoleteTenantAuthInfo;
import com.digiwin.dap.middleware.cac.domain.PurchaseVO;
import com.digiwin.dap.middleware.cac.domain.UsageCountResultVO;
import com.digiwin.dap.middleware.cac.domain.enumeration.AuthCategory;
import com.digiwin.dap.middleware.cac.domain.enumeration.CountPattern;
import com.digiwin.dap.middleware.cac.domain.enumeration.PaymentType;
import com.digiwin.dap.middleware.cac.entity.PurchaseCount;
import com.digiwin.dap.middleware.cac.mapper.PurchaseCountMapper;
import com.digiwin.dap.middleware.cac.service.basic.PurchaseCountCrudService;
import com.digiwin.dap.middleware.cac.service.business.AuthorizeRegistrarService;
import com.digiwin.dap.middleware.cac.service.paymenttype.CalcUtil;
import com.digiwin.dap.middleware.cac.service.paymenttype.PaymentTypeService;
import com.digiwin.dap.middleware.cac.service.paymenttype.impl.AbstractPaymentTypeService;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PaymentTypePersonMonthServiceImpl
extends AbstractPaymentTypeService
implements PaymentTypeService {
    @Autowired
    private PurchaseCountMapper purchaseCountMapper;
    @Autowired
    private PurchaseCountCrudService purchaseCountCrudService;
    @Autowired
    private AuthorizeRegistrarService authorizeRegistrarService;
    @Autowired
    private EnvProperties envProperties;

    public boolean support(int paymentType) {
        return PaymentType.PersonMonth.ordinal() == paymentType;
    }

    public void decidePaymentType(CloudPurchaseDTO entityPurchase, PurchaseVO domainPurchase) {
        entityPurchase.setCountType(CountPattern.Traditional.name());
        entityPurchase.setTotalUsage(-1);
        entityPurchase.setRemainingUsage(-1);
        if (Objects.equals(0, this.envProperties.getCloud())) {
            this.cloudDecidePaymentType(entityPurchase, domainPurchase);
        } else {
            this.groundDecidePaymentType(entityPurchase, domainPurchase);
        }
    }

    public void decideUpdatePaymentType(CloudPurchaseDTO entityPurchase, PurchaseVO domainPurchase) {
        entityPurchase.setStrategyId(domainPurchase.getSellingStrategy().getId());
        if (domainPurchase.isGround()) {
            entityPurchase.setTotalCount(domainPurchase.getTotalCount());
            this.groundDecideUpdatePaymentType(entityPurchase, domainPurchase);
        } else {
            this.cloudDecideUpdatePaymentType(entityPurchase, domainPurchase);
        }
    }

    private void groundDecideUpdatePaymentType(CloudPurchaseDTO purchase, PurchaseVO info) {
        if (info.getExpiredTime() == null) {
            purchase.setExpiredDateTime(CacConstants.PERMANENT_TIME);
        } else {
            purchase.setExpiredDateTime(info.getExpiredTime());
        }
        info.getSellingStrategy().getEnabledModules().forEach(module -> {
            EnabledModuleDTO target = purchase.getModules().stream().filter(m -> m.getId().equals(module.getId())).findFirst().orElse(null);
            if (target == null) {
                purchase.getModules().add(new EnabledModuleDTO(module.getId(), module.getName(), -1, -1, LocalDateTime.now(), info.getExpiredTime(), module));
            } else {
                target.setExpiredTime(info.getExpiredTime());
            }
        });
    }

    private void cloudDecideUpdatePaymentType(CloudPurchaseDTO entityPurchase, PurchaseVO domainPurchase) {
        CalcExpire calcExpire = CalcExpire.get((PurchaseVO)domainPurchase, (LocalDateTime)entityPurchase.getExpiredDateTime());
        entityPurchase.setExpiredDateTime(CalcUtil.calcUpdatePurchaseExpiredTime((CalcExpire)calcExpire));
        if (calcExpire.getCategory() == AuthCategory.Dealer) {
            if (entityPurchase.getExpiredDateTime().isAfter(LocalDateTime.now())) {
                entityPurchase.setTotalCount(domainPurchase.getTotalCount() + entityPurchase.getTotalCount());
            } else {
                entityPurchase.setTotalCount(domainPurchase.getTotalCount());
            }
        } else if (calcExpire.getCategory() == AuthCategory.PlatformAuto) {
            entityPurchase.setTotalCount(Math.max(domainPurchase.getTotalCount(), entityPurchase.getTotalCount()));
        } else if (calcExpire.getCategory() == AuthCategory.Accessory || calcExpire.getCategory() == AuthCategory.AccessoryPlatform) {
            if (calcExpire.getPurchaseActualDate().isBefore(LocalDateTime.now())) {
                entityPurchase.setTotalCount(domainPurchase.getTotalCount());
            }
        } else {
            entityPurchase.setTotalCount(domainPurchase.getTotalCount());
        }
        LocalDateTime maxExpiredTime = entityPurchase.getExpiredDateTime();
        for (AuthorizationModuleVO domainModule : domainPurchase.getSellingStrategy().getEnabledModules()) {
            EnabledModuleDTO entityModule = entityPurchase.getModules().stream().filter(m -> m.getId().equals(domainModule.getId())).findFirst().orElse(null);
            calcExpire.module(entityModule, domainModule);
            LocalDateTime moduleExpiredTime = CalcUtil.calcUpdateModuleExpiredTime((CalcExpire)calcExpire);
            if (entityModule == null) {
                entityPurchase.getModules().add(new EnabledModuleDTO(domainModule.getId(), domainModule.getName(), -1, -1, calcExpire.getNow(), moduleExpiredTime, domainModule));
            } else {
                entityModule.setName(domainModule.getName());
                entityModule.setExpiredTime(moduleExpiredTime);
                entityModule.setActions(domainModule.updateActionString(entityModule));
            }
            if (!moduleExpiredTime.isAfter(maxExpiredTime)) continue;
            maxExpiredTime = moduleExpiredTime;
        }
        if (calcExpire.getCategory() == AuthCategory.OverlayTenancyPeriod && maxExpiredTime.isAfter(entityPurchase.getExpiredDateTime())) {
            entityPurchase.setExpiredDateTime(maxExpiredTime);
        }
    }

    public void decideUpdatePaymentType(CloudPurchaseDTO purchase, EditParamVO editParamVO) {
        if (editParamVO.getTotalUsage() != null) {
            purchase.setTotalCount(editParamVO.getTotalUsage().intValue());
        }
        if (editParamVO.getExpiredTime() != null) {
            purchase.setEffectiveDateTime(editParamVO.getEffectiveTime());
            purchase.setExpiredDateTime(editParamVO.getExpiredTime().with(LocalTime.MAX).withNano(0));
        }
        if (editParamVO.getModules() != null) {
            editParamVO.getModules().forEach(module -> {
                EnabledModuleDTO target = purchase.getModules().stream().filter(m -> m.getId().equals(module.getId())).findFirst().orElse(null);
                if (target != null) {
                    target.setEffectiveTime(editParamVO.getEffectiveTime());
                    target.setExpiredTime(module.getExpiredTime().with(LocalTime.MAX).withNano(0));
                    target.setTotalUsage(-1);
                    target.setRemainingUsage(-1);
                    target.setActions(module.updateActionString(target));
                    if (module.getExpiredTime().with(LocalTime.MAX).withNano(0).isAfter(editParamVO.getExpiredTime().with(LocalTime.MAX).withNano(0))) {
                        purchase.setExpiredDateTime(module.getExpiredTime().with(LocalTime.MAX).withNano(0));
                    }
                } else {
                    purchase.getModules().add(new EnabledModuleDTO(module.getId(), module.getName(), -1, -1, editParamVO.getEffectiveTime(), module.getExpiredTime(), module));
                }
            });
        }
    }

    public void decideUpdatePaymentType(CloudPurchaseDTO purchase, List<AuthorizationModuleVO> modules) {
        this.processAddModuleOrAction(purchase, modules);
    }

    public EnabledModuleDTO getNewModule(CloudPurchaseDTO purchase, AuthorizationModuleVO module) {
        return new EnabledModuleDTO(module.getId(), module.getName(), -1, -1, LocalDateTime.now(), purchase.getExpiredDateTime(), module);
    }

    public Boolean checkAuthorizationValid(CloudPurchaseDTO purchase) {
        return LocalDateTime.now().isAfter(purchase.getEffectiveDateTime()) && LocalDateTime.now().isBefore(purchase.getExpiredDateTime());
    }

    public Boolean checkModuleInvalid(int paymentType, EnabledModuleDTO module) {
        return LocalDateTime.now().isBefore(module.getExpiredTime());
    }

    public UsageCountResultVO getAuthorizationCountingResult(AuthorizationVO authorizationVO, AuthorizationModuleVO module) {
        return new UsageCountResultVO(LocalDateTime.now().isBefore(module.getExpiredTime()), -1, -1);
    }

    private void groundDecidePaymentType(CloudPurchaseDTO purchase, PurchaseVO info) {
        if (info.getExpiredTime() == null) {
            purchase.setExpiredDateTime(CacConstants.PERMANENT_TIME);
            purchase.getModules().forEach(module -> module.setExpiredTime(CacConstants.PERMANENT_TIME));
        } else {
            purchase.setExpiredDateTime(info.getExpiredTime());
            purchase.getModules().forEach(module -> {
                module.setTotalUsage(-1);
                module.setRemainingUsage(-1);
                module.setEffectiveTime(LocalDateTime.now());
                module.setExpiredTime(info.getExpiredTime());
            });
        }
    }

    private void cloudDecidePaymentType(CloudPurchaseDTO entityPurchase, PurchaseVO domainPurchase) {
        CalcExpire calcExpire = CalcExpire.get((PurchaseVO)domainPurchase);
        entityPurchase.setExpiredDateTime(CalcUtil.calcNewPurchaseExpiredTime((CalcExpire)calcExpire));
        entityPurchase.getModules().forEach(module -> {
            module.setTotalUsage(-1);
            module.setRemainingUsage(-1);
            module.setEffectiveTime(calcExpire.getEffectiveDateTime());
            calcExpire.module(module.getExpiredTime());
            module.setExpiredTime(CalcUtil.calcNewModuleExpiredTime((CalcExpire)calcExpire));
        });
    }

    public void deleteAuthorization(CancelAuth cancel) {
        CancelAuth old = this.purchaseCountMapper.findPurchase(cancel.getTenantId(), cancel.getGoodsSid());
        if (old == null) {
            return;
        }
        if (!Objects.equals(old.getPaymentType(), cancel.getPaymentType())) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_10002, new Object[]{cancel.getPaymentType(), old.getPaymentType()});
        }
        int leftTotalCount = old.getTotalCount() - cancel.getTotalCount();
        int leftUserCount = leftTotalCount - old.getUserCount();
        if (leftUserCount == 0 && leftTotalCount == 0) {
            this.authorizeRegistrarService.deleteByTenantIdAndGoodsSid(cancel.getTenantId(), cancel.getGoodsSid());
        } else if (leftUserCount > 0 || leftUserCount == 0 && leftTotalCount > 0) {
            PurchaseCount purchaseCount = this.purchaseCountCrudService.findByPurchaseId(old.getPurchaseId());
            if (purchaseCount != null) {
                purchaseCount.setTotalCountBound(leftTotalCount);
                this.purchaseCountCrudService.updateByPurchaseId(purchaseCount);
            }
        } else {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_10004, new Object[]{cancel.getTotalCount(), old.getUserCount()});
        }
    }

    public Boolean checkObsoleteAuthEnable(CloudPurchaseDTO authInfo, ObsoleteTenantAuthInfo updateAuthInfo) {
        if (null != updateAuthInfo.getOldExpiredDateTime() && null != updateAuthInfo.getOldTotalUsageBound()) {
            boolean expireDate = updateAuthInfo.getPlatform() != false ? updateAuthInfo.getOldExpiredDateTime().isBefore(authInfo.getExpiredDateTime()) : !updateAuthInfo.getExpiredDateTime().equals(authInfo.getExpiredDateTime());
            boolean totalCount = updateAuthInfo.getTotalCountBound().intValue() != authInfo.getTotalCount();
            return expireDate || totalCount;
        }
        boolean expireDate = updateAuthInfo.getExpiredDateTime().isBefore(authInfo.getExpiredDateTime());
        boolean totalCount = updateAuthInfo.getTotalCountBound() < authInfo.getTotalCount();
        return expireDate || totalCount;
    }
}

