/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.service.paymenttype.impl;

import com.digiwin.dap.middleware.cac.constant.CacConstants;
import com.digiwin.dap.middleware.cac.domain.AuthorizationModuleVO;
import com.digiwin.dap.middleware.cac.domain.AuthorizationVO;
import com.digiwin.dap.middleware.cac.domain.CloudPurchaseDTO;
import com.digiwin.dap.middleware.cac.domain.EditParamVO;
import com.digiwin.dap.middleware.cac.domain.EnabledModuleDTO;
import com.digiwin.dap.middleware.cac.domain.ObsoleteTenantAuthInfo;
import com.digiwin.dap.middleware.cac.domain.PurchaseVO;
import com.digiwin.dap.middleware.cac.domain.UsageCountResultVO;
import com.digiwin.dap.middleware.cac.domain.enumeration.CountPattern;
import com.digiwin.dap.middleware.cac.domain.enumeration.OrderSourceEnum;
import com.digiwin.dap.middleware.cac.domain.enumeration.PaymentType;
import com.digiwin.dap.middleware.cac.entity.PurchaseCount;
import com.digiwin.dap.middleware.cac.service.basic.PurchaseCountCrudService;
import com.digiwin.dap.middleware.cac.service.paymenttype.PaymentTypeService;
import com.digiwin.dap.middleware.cac.service.paymenttype.impl.AbstractPaymentTypeService;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PaymentTypeYearServiceImpl
extends AbstractPaymentTypeService
implements PaymentTypeService {
    @Autowired
    private PurchaseCountCrudService purchaseCountCrudService;

    public boolean support(int paymentType) {
        return PaymentType.Year.ordinal() == paymentType;
    }

    public void decidePaymentType(CloudPurchaseDTO entityPurchase, PurchaseVO domainPurchase) {
        entityPurchase.setCountType(CountPattern.Traditional.name());
        boolean bossManualAuthorization = OrderSourceEnum.BossManualAuthorization.name().equals(domainPurchase.getOrderSource());
        if (bossManualAuthorization) {
            entityPurchase.setExpiredDateTime(domainPurchase.getExpiredTime());
        } else {
            LocalDateTime expiredTime = entityPurchase.getEffectiveDateTime().plusYears((long)domainPurchase.getOrderNumber() * (long)domainPurchase.getSellingStrategy().getTenancyPeriod());
            if (expiredTime.isAfter(CacConstants.PERMANENT_TIME)) {
                expiredTime = CacConstants.PERMANENT_TIME;
            }
            entityPurchase.setExpiredDateTime(expiredTime);
        }
        entityPurchase.getModules().forEach(module -> {
            module.setTotalUsage(-1);
            module.setRemainingUsage(-1);
            module.setEffectiveTime(entityPurchase.getEffectiveDateTime());
            if (bossManualAuthorization) {
                if (module.getExpiredTime() == null) {
                    module.setExpiredTime(entityPurchase.getExpiredDateTime());
                }
            } else {
                module.setExpiredTime(entityPurchase.getExpiredDateTime());
            }
        });
    }

    public void decideUpdatePaymentType(CloudPurchaseDTO entityPurchase, PurchaseVO domainPurchase) {
        boolean bossManualAuthorization = OrderSourceEnum.BossManualAuthorization.name().equals(domainPurchase.getOrderSource());
        int plusMonths = domainPurchase.getOrderNumber() * domainPurchase.getSellingStrategy().getTenancyPeriod();
        entityPurchase.setTotalCount(domainPurchase.getTotalCount());
        LocalDateTime now = LocalDateTime.now();
        domainPurchase.getSellingStrategy().getEnabledModules().forEach(module -> {
            EnabledModuleDTO target = entityPurchase.getModules().stream().filter(m -> m.getId().equals(module.getId())).findFirst().orElse(null);
            if (target == null) {
                LocalDateTime expiredTime = bossManualAuthorization ? (module.getExpiredTime() != null ? module.getExpiredTime() : domainPurchase.getExpiredTime()) : now.plusYears(plusMonths);
                entityPurchase.getModules().add(new EnabledModuleDTO(module.getId(), module.getName(), -1, -1, now, expiredTime, module));
            } else {
                target.setName(module.getName());
                LocalDateTime expiredTime = bossManualAuthorization ? (module.getExpiredTime() != null ? module.getExpiredTime() : domainPurchase.getExpiredTime()) : target.getExpiredTime().plusYears(plusMonths);
                if (expiredTime.isAfter(CacConstants.PERMANENT_TIME)) {
                    expiredTime = CacConstants.PERMANENT_TIME;
                }
                target.setExpiredTime(expiredTime);
                target.setActions(module.updateActionString(target));
            }
        });
        LocalDateTime newestTime = LocalDateTime.now().plusMonths(plusMonths);
        if (bossManualAuthorization) {
            entityPurchase.setExpiredDateTime(domainPurchase.getExpiredTime());
        } else if (newestTime.isAfter(entityPurchase.getExpiredDateTime())) {
            entityPurchase.setExpiredDateTime(newestTime);
        }
    }

    public void decideUpdatePaymentType(CloudPurchaseDTO purchase, EditParamVO editParamVO) {
    }

    public void decideUpdatePaymentType(CloudPurchaseDTO purchase, List<AuthorizationModuleVO> modules) {
        this.processAddModuleOrAction(purchase, modules);
    }

    public Boolean checkAuthorizationValid(CloudPurchaseDTO purchase) {
        return LocalDateTime.now().isAfter(purchase.getEffectiveDateTime()) && LocalDateTime.now().isBefore(purchase.getExpiredDateTime());
    }

    public Boolean checkModuleInvalid(int paymentType, EnabledModuleDTO module) {
        return LocalDateTime.now().isBefore(module.getExpiredTime());
    }

    public UsageCountResultVO getAuthorizationCountingResult(AuthorizationVO authorizationVO, AuthorizationModuleVO module) {
        return new UsageCountResultVO(LocalDateTime.now().isBefore(module.getExpiredTime()), -1, -1);
    }

    public UsageCountResultVO decrementUsageCount(LocalDateTime expiredDateTime, PurchaseCount purchaseCount, Integer decreaseCount) {
        return new UsageCountResultVO(LocalDateTime.now().isBefore(expiredDateTime), purchaseCount.getRemainUsageBound(), purchaseCount.getTotalUsageBound());
    }

    public UsageCountResultVO addUsageCount(LocalDateTime expiredDateTime, PurchaseCount purchaseCount, Integer decreaseCount) {
        if (Objects.isNull(decreaseCount)) {
            decreaseCount = 1;
        }
        if (purchaseCount.getRemainUsageBound() + decreaseCount <= purchaseCount.getTotalUsageBound() && LocalDateTime.now().isBefore(expiredDateTime)) {
            purchaseCount.setRemainUsageBound(purchaseCount.getRemainUsageBound() + decreaseCount);
            this.purchaseCountCrudService.updateByPurchaseId(purchaseCount);
            return new UsageCountResultVO(true, purchaseCount.getRemainUsageBound(), purchaseCount.getTotalUsageBound());
        }
        return new UsageCountResultVO(false, purchaseCount.getRemainUsageBound(), purchaseCount.getTotalUsageBound());
    }

    public Boolean checkObsoleteAuthEnable(CloudPurchaseDTO authInfo, ObsoleteTenantAuthInfo updateAuthInfo) {
        if (null != updateAuthInfo.getOldExpiredDateTime() && null != updateAuthInfo.getOldTotalUsageBound()) {
            boolean expireDate = updateAuthInfo.getPlatform() != false ? updateAuthInfo.getOldExpiredDateTime().isBefore(authInfo.getExpiredDateTime()) : !updateAuthInfo.getExpiredDateTime().equals(authInfo.getExpiredDateTime());
            return expireDate;
        }
        boolean expireDate = updateAuthInfo.getExpiredDateTime().isBefore(authInfo.getExpiredDateTime());
        return expireDate;
    }
}

