/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.support.aspect;

import com.digiwin.dap.middleware.cac.domain.UserAuthorizationInfoVO;
import com.digiwin.dap.middleware.cac.domain.remote.SysVO;
import com.digiwin.dap.middleware.cac.support.aspect.RedisConstants;
import com.digiwin.dap.middleware.cache.RedisUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.BoundSetOperations;

public class CacheUtil {
    public static Logger LOGGER = LoggerFactory.getLogger(CacheUtil.class);

    public static void deleteKey4UserAuth(String tenantId, String userId, List<String> appIds) {
        HashSet deleteKeys = new HashSet();
        appIds.forEach(a -> {
            String redisKey = RedisConstants.getAuthKey((String)tenantId, (String)userId, (String)a);
            deleteKeys.add(redisKey);
            LOGGER.info("\u5220\u9664\u7684key:{}", (Object)redisKey);
        });
        RedisUtils.delete(deleteKeys);
    }

    public static void deleteKey4UserAuth(List<UserAuthorizationInfoVO> users, List<SysVO> appInfos) {
        ArrayList redisKeys = new ArrayList();
        users.stream().forEach(user -> {
            redisKeys.add(RedisConstants.getAuthKey((String)user.getTenantId(), (String)user.getUserId(), (String)user.getAppId()));
            Optional<SysVO> sysVO = appInfos.stream().filter(a -> user.getAppId().equals(a.getId())).findFirst();
            sysVO.ifPresent(vo -> vo.getPlatformVOS().forEach(p -> redisKeys.add(RedisConstants.getAuthKey((String)user.getTenantId(), (String)user.getUserId(), (String)p))));
        });
        RedisUtils.delete(redisKeys);
    }

    public static void deleteKey4IamPermission(String tenantId, String goodsCode) {
        List allKeys;
        BoundSetOperations boundSetOps = RedisUtils.getRedisTemplate().boundSetOps((Object)RedisConstants.getPermSys((String)goodsCode));
        Set objects = boundSetOps.members();
        if (objects != null && !objects.isEmpty() && !(allKeys = objects.stream().map(Object::toString).filter(key -> key.contains(tenantId + "::" + goodsCode)).collect(Collectors.toList())).isEmpty()) {
            RedisUtils.delete(allKeys);
            boundSetOps.remove(allKeys.toArray());
        }
    }
}

