/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.support.aspect;

import com.digiwin.dap.middleware.cac.domain.FieldValue;
import com.digiwin.dap.middleware.cac.support.remote.GmcService;
import com.digiwin.dap.middleware.cac.support.remote.IamService;
import com.digiwin.dap.middleware.util.UserUtils;
import com.github.pagehelper.util.ExecutorUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.springframework.beans.factory.annotation.Autowired;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class DataPolicyInterceptor
implements Interceptor {
    private static final int PARAM_COUNT = 4;
    private static final String DATA_POLICY_QUERY = "PurchaseMapper.findPurchases";
    private static final String DATA_POLICY_QUERY_AUTH = "PurchaseMapper.queryPurchaseDetail";
    private static final String DATA_POLICY_QUERY_COUNT_API_INVOKE = "StatisticInvokeLogMapper.searchProductMonthInvokeLogsByCondition";
    private static final List<String> OPERATOR = Arrays.asList("and", "or");
    @Autowired
    private IamService iamService;
    @Autowired
    private GmcService gmcService;

    public void setProperties(Properties properties) {
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public Object intercept(Invocation invocation) throws Throwable {
        CacheKey cacheKey;
        BoundSql boundSql;
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement)args[0];
        Object parameter = args[1];
        RowBounds rowBounds = (RowBounds)args[2];
        ResultHandler resultHandler = (ResultHandler)args[3];
        Executor executor = (Executor)invocation.getTarget();
        if (args.length == 4) {
            boundSql = ms.getBoundSql(parameter);
            cacheKey = executor.createCacheKey(ms, parameter, rowBounds, boundSql);
        } else {
            cacheKey = (CacheKey)args[4];
            boundSql = (BoundSql)args[5];
        }
        String dataPolicySql = boundSql.getSql();
        if (ms.getId().endsWith(DATA_POLICY_QUERY) || ms.getId().endsWith(DATA_POLICY_QUERY_AUTH)) {
            dataPolicySql = this.getSql(dataPolicySql, 1);
        } else if (ms.getId().endsWith(DATA_POLICY_QUERY_COUNT_API_INVOKE)) {
            dataPolicySql = this.getSql(dataPolicySql, 2);
        }
        BoundSql dataBoundSql = new BoundSql(ms.getConfiguration(), dataPolicySql, boundSql.getParameterMappings(), parameter);
        Map additionalParameters = ExecutorUtil.getAdditionalParameter((BoundSql)boundSql);
        for (String key : additionalParameters.keySet()) {
            dataBoundSql.setAdditionalParameter(key, additionalParameters.get(key));
        }
        return executor.query(ms, parameter, rowBounds, resultHandler, cacheKey, dataBoundSql);
    }

    private String getSql(String sql, int type) {
        Map map = this.iamService.getRowPermission(UserUtils.getToken(), type);
        if (null == map) {
            if (2 == type) {
                String groupByBeforeSql = sql.substring(0, sql.indexOf("group by"));
                String groupByAfterSql = sql.substring(sql.indexOf("group by"));
                String tempSql = "product_tenant_id = '0'";
                return String.format("%s and %s %s", groupByBeforeSql, tempSql, groupByAfterSql);
            }
            return sql + " and p.id = 0";
        }
        boolean superadmin = Boolean.valueOf(map.get("superadmin").toString());
        if (superadmin) {
            return sql;
        }
        Map rowMap = (Map)map.get("rowPermission");
        if (rowMap.isEmpty()) {
            if (2 == type) {
                String groupByBeforeSql = sql.substring(0, sql.indexOf("group by"));
                String groupByAfterSql = sql.substring(sql.indexOf("group by"));
                String tempSql = "product_tenant_id = '0'";
                return String.format("%s and %s %s", groupByBeforeSql, tempSql, groupByAfterSql);
            }
            return sql + " and p.id = 0";
        }
        if (2 == type) {
            String groupByBeforeSql = sql.substring(0, sql.indexOf("group by"));
            String groupByAfterSql = sql.substring(sql.indexOf("group by"));
            String tempSql = this.getSql((Object)rowMap, null).replace("productTenantId", "product_tenant_id");
            return String.format("%s and %s %s", groupByBeforeSql, tempSql, groupByAfterSql);
        }
        String temp = this.getSql((Object)rowMap, null).replace("goodsCode", "p.product_code").replace("categoryId", "p.product_type");
        return String.format("%s and %s", sql, temp);
    }

    private String getSql(Object object, String operator) {
        if (null == object) {
            return "";
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            if (0 == map.size()) {
                return "";
            }
            FieldValue fieldValue = new FieldValue(map);
            if (OPERATOR.contains(fieldValue.getFilterType())) {
                return this.getSql(fieldValue.getFilterValue(), fieldValue.getFilterType());
            }
            if ("productCode".equals(fieldValue.getFilterField())) {
                List codes = this.gmcService.getGoodsCodeByProductCodes((List)fieldValue.getFilterValue());
                if (codes.isEmpty()) {
                    return "p.product_code in ('-1')";
                }
                return String.format("p.product_code in ('%s')", String.join((CharSequence)"','", codes));
            }
            return fieldValue.getWhere();
        }
        if (object instanceof List) {
            List list = (List)object;
            ArrayList<String> values = new ArrayList<String>();
            for (Object o : list) {
                String temp = this.getSql(o, null);
                if ("".equals(temp)) continue;
                values.add(temp);
            }
            int size = values.size();
            if (size == 1) {
                return (String)values.get(0);
            }
            if (size > 1) {
                String temp = String.join((CharSequence)String.format(" %s ", operator), values);
                return String.format("(%s)", temp);
            }
        }
        return "";
    }
}

