/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.support.aspect;

import com.digiwin.dap.middleware.cac.domain.CloudPurchaseDTO;
import com.digiwin.dap.middleware.cac.entity.Purchase;
import com.digiwin.dap.middleware.cac.mapper.CacheMapper;
import com.digiwin.dap.middleware.cac.support.aspect.CacheUtil;
import com.digiwin.dap.middleware.cac.support.remote.IamService;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Aspect
@Component
public class RefreshPurchase {
    private static final Logger logger = LoggerFactory.getLogger(RefreshPurchase.class);
    @Autowired
    private CacheMapper cacheMapper;
    @Autowired
    private IamService iamService;

    @AfterReturning(value="execution(public * com.digiwin.dap.middleware.service.EntityManagerService+.update(..)) && target(com.digiwin.dap.middleware.cac.service.basic.PurchaseCrudService)")
    public void deleteRedis1(JoinPoint joinPoint) {
        try {
            Object object = joinPoint.getArgs()[0];
            if (object instanceof Purchase) {
                Purchase purchase = (Purchase)object;
                List users = this.cacheMapper.findUserByPurchaseId(purchase.getId());
                CacheUtil.deleteKey4UserAuth((List)users, (List)this.iamService.getPlatformInfos(purchase.getCustomerId(), Arrays.asList(purchase.getProductCode())));
                CacheUtil.deleteKey4IamPermission((String)purchase.getCustomerId(), (String)purchase.getProductCode());
            }
        }
        catch (Exception e) {
            logger.error("EntityManagerService.create/update\u5207\u7247\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
    }

    @AfterReturning(value="execution(public * com.digiwin.dap.middleware.cac.service.business.AuthorizeRegistrarService.batchUpdate(..))")
    public void deleteRedis2(JoinPoint joinPoint) {
        try {
            List cloudPurchases = (List)joinPoint.getArgs()[0];
            List purchaseIds = cloudPurchases.stream().map(CloudPurchaseDTO::getPurchaseId).collect(Collectors.toList());
            List users = this.cacheMapper.findUserByPurchaseIds(purchaseIds);
            if (!CollectionUtils.isEmpty((Collection)users)) {
                CacheUtil.deleteKey4UserAuth((List)users, (List)this.iamService.getPlatformInfos(((CloudPurchaseDTO)cloudPurchases.get(0)).getCustomerId(), cloudPurchases.stream().map(CloudPurchaseDTO::getProductCode).collect(Collectors.toList())));
            }
            for (CloudPurchaseDTO purchase : cloudPurchases) {
                CacheUtil.deleteKey4IamPermission((String)purchase.getCustomerId(), (String)purchase.getProductCode());
            }
        }
        catch (Exception e) {
            logger.error("AuthorizeRegistrarService.batchUpdate\u5207\u7247\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
    }

    @Before(value="execution(public * com.digiwin.dap.middleware.cac.service.basic.PurchaseCrudService.deletePurchase(java.util.List)) && args(purchases)")
    public void deleteRedis3(List<Purchase> purchases) {
        try {
            if (purchases != null && !purchases.isEmpty()) {
                List purchaseIds = purchases.stream().map(Purchase::getId).collect(Collectors.toList());
                List users = this.cacheMapper.findUserByPurchaseIds(purchaseIds);
                if (!CollectionUtils.isEmpty((Collection)users)) {
                    CacheUtil.deleteKey4UserAuth((List)users, (List)this.iamService.getPlatformInfos(purchases.get(0).getCustomerId(), purchases.stream().map(Purchase::getProductCode).collect(Collectors.toList())));
                }
                for (Purchase purchase : purchases) {
                    CacheUtil.deleteKey4IamPermission((String)purchase.getCustomerId(), (String)purchase.getProductCode());
                }
            }
        }
        catch (Exception e) {
            logger.error("PurchaseCrudService.deletePurchases\u5207\u7247\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
    }

    @Before(value="execution(public * com.digiwin.dap.middleware.cac.service.basic.PurchaseCrudService.deletePurchase(com.digiwin.dap.middleware.cac.entity.Purchase))  && args(purchase)")
    public void deleteRedis4(Purchase purchase) {
        try {
            if (purchase != null) {
                List users = this.cacheMapper.findUserByPurchaseId(purchase.getId());
                CacheUtil.deleteKey4UserAuth((List)users, (List)this.iamService.getPlatformInfos(purchase.getCustomerId(), Arrays.asList(purchase.getProductCode())));
                CacheUtil.deleteKey4IamPermission((String)purchase.getCustomerId(), (String)purchase.getProductCode());
            }
        }
        catch (Exception e) {
            logger.error("PurchaseCrudService.deletePurchase\u5207\u7247\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
    }

    @AfterReturning(value="execution(public * com.digiwin.dap.middleware.cac.service.business.AuthorizeRegistrarService.update(..))")
    public void deleteRedis5(JoinPoint joinPoint) {
        try {
            CloudPurchaseDTO cloudPurchase = (CloudPurchaseDTO)joinPoint.getArgs()[0];
            List users = this.cacheMapper.findUserByPurchaseId(cloudPurchase.getPurchaseId());
            CacheUtil.deleteKey4UserAuth((List)users, (List)this.iamService.getPlatformInfos(cloudPurchase.getCustomerId(), Arrays.asList(cloudPurchase.getProductCode())));
            CacheUtil.deleteKey4IamPermission((String)cloudPurchase.getCustomerId(), (String)cloudPurchase.getProductCode());
        }
        catch (Exception e) {
            logger.error("AuthorizeRegistrarService.batchUpdate\u5207\u7247\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
    }
}

