/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.support.aspect;

import com.digiwin.dap.middleware.cac.domain.remote.SysVO;
import com.digiwin.dap.middleware.cac.entity.Purchase;
import com.digiwin.dap.middleware.cac.mapper.CacheMapper;
import com.digiwin.dap.middleware.cac.support.aspect.CacheUtil;
import com.digiwin.dap.middleware.cac.support.remote.IamService;
import com.digiwin.dap.middleware.cache.RedisUtils;
import com.digiwin.dap.middleware.util.JsonUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Aspect
@Component
public class RefreshUserInCount {
    private static final Logger logger = LoggerFactory.getLogger(RefreshUserInCount.class);
    @Autowired
    private CacheMapper cacheMapper;
    @Autowired
    private IamService iamService;

    @Before(value="execution(public * com.digiwin.dap.middleware.cac.service.basic.UserInCountingCrudService.addUser(java.lang.String, java.lang.String)) && args(purchaseId,userId)", argNames="purchaseId,userId")
    public void deleteRedis1(String purchaseId, String userId) {
        try {
            Purchase purchase = this.cacheMapper.findByPurchaseId(purchaseId);
            if (purchase != null && "landingconsole".equals(purchase.getProductCode())) {
                RedisUtils.delete((String)String.format("iam:permission:action:%s::%s::%s", userId, purchase.getCustomerId(), "DigiwinCloud"));
            }
        }
        catch (Exception e) {
            logger.error("UserInCountingCrudService.addUser\u5207\u7247\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
    }

    @Before(value="execution(public * com.digiwin.dap.middleware.cac.service.basic.UserInCountingCrudService.removeUser(java.lang.String, java.lang.String)) && args(purchaseId,userId)", argNames="purchaseId,userId")
    public void deleteRedis2(String purchaseId, String userId) {
        try {
            Purchase purchase = this.cacheMapper.findByPurchaseId(purchaseId);
            if (purchase != null) {
                CacheUtil.deleteKey4UserAuth((String)purchase.getCustomerId(), (String)userId, (List)this.getPlatFormSysIds(purchase.getCustomerId(), purchase.getProductCode()));
                if ("landingconsole".equals(purchase.getProductCode())) {
                    RedisUtils.delete((String)String.format("iam:permission:action:%s::%s::%s", userId, purchase.getCustomerId(), "@digiwin.com"));
                }
            }
        }
        catch (Exception e) {
            logger.error("UserInCountingCrudService.removeUser\u5207\u7247\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
    }

    @Before(value="execution(public * com.digiwin.dap.middleware.cac.service.basic.UserInCountingCrudService.batchRemoveUser(java.lang.String, java.util.List)) && args(purchaseId,userIds)", argNames="purchaseId,userIds")
    public void deleteRedis3(String purchaseId, List<String> userIds) {
        try {
            Purchase purchase = this.cacheMapper.findByPurchaseId(purchaseId);
            if (purchase != null) {
                for (String userId : userIds) {
                    CacheUtil.deleteKey4UserAuth((String)purchase.getCustomerId(), (String)userId, (List)this.getPlatFormSysIds(purchase.getCustomerId(), purchase.getProductCode()));
                    if (!"landingconsole".equals(purchase.getProductCode())) continue;
                    RedisUtils.delete((String)String.format("iam:permission:action:%s::%s::%s", userId, purchase.getCustomerId(), "@digiwin.com"));
                }
            }
        }
        catch (Exception e) {
            logger.error("UserInCountingCrudService.batchRemoveUser\u5207\u7247\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
    }

    private List<String> getPlatFormSysIds(String tenantId, String appId) {
        List sysVOS = this.iamService.getPlatformInfos(tenantId, Arrays.asList(appId));
        ArrayList<String> appIds = new ArrayList<String>();
        appIds.add(appId);
        if (!CollectionUtils.isEmpty((Collection)sysVOS) && !CollectionUtils.isEmpty((Collection)((SysVO)sysVOS.get(0)).getPlatformVOS())) {
            appIds.addAll(((SysVO)sysVOS.get(0)).getPlatformVOS());
        }
        logger.info("\u5e94\u7528\u4fe1\u606f:{}", (Object)JsonUtils.objToJson(appIds));
        return appIds;
    }
}

