/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.support.remote.impl;

import com.digiwin.dap.middleware.cac.domain.EnvProperties;
import com.digiwin.dap.middleware.cac.domain.remote.ResourceGoodsPurchaseRecordVO;
import com.digiwin.dap.middleware.cac.domain.remote.ResourceGoodsRequest;
import com.digiwin.dap.middleware.cac.domain.remote.ResourceGoodsUseRecordVO;
import com.digiwin.dap.middleware.cac.support.remote.DmcService;
import com.digiwin.dap.middleware.cac.support.remote.impl.GmcServiceImpl;
import com.digiwin.dap.middleware.constant.GlobalConstants;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.support.DapHttpService;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class DmcServiceImpl
implements DmcService {
    private static final Logger logger = LoggerFactory.getLogger(GmcServiceImpl.class);
    @Autowired
    private EnvProperties envProperties;
    @Resource(name="dapRetryRestTemplate")
    private RestTemplate dapRetryRestTemplate;
    @Autowired
    private DapHttpService dapHttpService;

    public List<ResourceGoodsPurchaseRecordVO> findResourceGoodsPurchaseRecord() {
        HttpHeaders headers = new HttpHeaders();
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, this.dapHttpService.getUserToken(""));
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        String url = this.envProperties.getDmcUri() + "/api/dmc/v2/resource/goods/purchase/record/search";
        try {
            ResponseEntity response = this.dapRetryRestTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return Optional.ofNullable(response.getBody()).map(StdData::getData).orElse(Collections.emptyList());
        }
        catch (Exception e) {
            logger.error("\u3010DMC\u3011 \u67e5\u8be2dmc\u8ba1\u91cf\u5546\u54c1\u4f7f\u7528\u60c5\u51b5\u5f02\u5e38", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public List<ResourceGoodsUseRecordVO> findResourceGoodsUseRecord(ResourceGoodsRequest request) {
        HttpHeaders headers = new HttpHeaders();
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, this.dapHttpService.getUserToken(""));
        HttpEntity httpEntity = new HttpEntity((Object)request, (MultiValueMap)headers);
        String url = this.envProperties.getDmcUri() + "/api/dmc/v2/resource/goods/use/record/search";
        try {
            ResponseEntity response = this.dapRetryRestTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return Optional.ofNullable(response.getBody()).map(StdData::getData).orElse(Collections.emptyList());
        }
        catch (Exception e) {
            logger.error("\u3010DMC\u3011 \u67e5\u8be2dmc\u8ba1\u91cf\u5546\u54c1\u4f7f\u7528\u8bb0\u5f55\u5f02\u5e38", (Throwable)e);
            return Collections.emptyList();
        }
    }
}

