/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.support.remote.impl;

import com.digiwin.dap.middleware.cac.constant.I18nError;
import com.digiwin.dap.middleware.cac.domain.EnvProperties;
import com.digiwin.dap.middleware.cac.domain.remote.GoodsMarketConfig;
import com.digiwin.dap.middleware.cac.domain.remote.GoodsStrategy;
import com.digiwin.dap.middleware.cac.domain.remote.GoodsVO;
import com.digiwin.dap.middleware.cac.domain.remote.GoodsVO2;
import com.digiwin.dap.middleware.cac.domain.remote.MarketingConfigDetailVO;
import com.digiwin.dap.middleware.cac.domain.remote.PaymentTypeVO;
import com.digiwin.dap.middleware.cac.support.remote.GmcService;
import com.digiwin.dap.middleware.constant.GlobalConstants;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.support.DapHttpService;
import com.digiwin.dap.middleware.util.ExceptionUtils;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.StringUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.pagehelper.PageSerializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class GmcServiceImpl
implements GmcService {
    private static final Logger logger = LoggerFactory.getLogger(GmcServiceImpl.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private DapHttpService dapHttpService;
    @Resource(name="dapRetryRestTemplate")
    private RestTemplate dapRetryRestTemplate;

    public List<PaymentTypeVO> getPaymentType() {
        String uri = this.envProperties.getGmcUri() + "/api/cloudgoods/paymenttype/all";
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity request = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.dapRetryRestTemplate.exchange(uri, HttpMethod.GET, request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return (List)response.getBody();
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.logError((String)"\u83b7\u53d6\u4ef7\u683c\u5355\u4f4d", (String)uri, null, (Exception)e), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public List<String> getGoodsCodeByProductCodes(List<String> productCodes) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            HttpEntity request = new HttpEntity(productCodes, (MultiValueMap)headers);
            String url = this.envProperties.getGmcUri() + "/api/gmc/v2/goods/code";
            ResponseEntity responseEntity = this.dapRetryRestTemplate.postForEntity(url, (Object)request, List.class, new Object[0]);
            return (List)responseEntity.getBody();
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u4ea7\u54c1code\u83b7\u53d6\u5546\u54c1code\u5f02\u5e38", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public List<String> getGoodsCodeByPlatformCode(String platformCode) {
        try {
            String userToken = this.dapHttpService.getUserToken("99990000");
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
            HttpEntity request = new HttpEntity(Collections.singletonMap("platformCode", platformCode), (MultiValueMap)headers);
            String url = this.envProperties.getGmcUri() + "/api/gmc/v2/goods/code/platform";
            StdData stdData = (StdData)this.dapRetryRestTemplate.postForObject(url, (Object)request, StdData.class, new Object[0]);
            return (List)stdData.getData();
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u5e73\u53f0code\u83b7\u53d6\u5546\u54c1code\u5f02\u5e38", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public List<String> getCurrentServicerGoods() {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            HashMap<String, Integer> body = new HashMap<String, Integer>();
            body.put("pageNum", 1);
            body.put("pageSize", 999);
            HttpEntity request = new HttpEntity(body, (MultiValueMap)headers);
            String url = this.envProperties.getGmcUri() + "/api/gmc/v2/goods/current/servicer/codes";
            ResponseEntity responseEntity = this.dapRetryRestTemplate.postForEntity(url, (Object)request, List.class, new Object[0]);
            return (List)responseEntity.getBody();
        }
        catch (Exception e) {
            logger.error("GMC \u83b7\u53d6\u5f53\u524d\u670d\u52a1\u5546\u7684\u5546\u54c1\u7f16\u7801\u8bf7\u6c42\u5931\u8d25", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public List<GoodsVO> getGoodsByGoodsCategoryId(List<String> goodsCodeList, String goodsCategoryId) {
        String url = this.envProperties.getGmcUri() + "/api/cloudgoods/category/goods";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put("goodsCodeList", goodsCodeList);
        requestMap.put("goodsCategoryId", goodsCategoryId);
        HttpEntity request = new HttpEntity(requestMap, (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.dapRetryRestTemplate.exchange(url, HttpMethod.POST, request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return Optional.ofNullable(responseEntity.getBody()).map(StdData::getData).orElseGet(Collections::emptyList);
        }
        catch (Exception e) {
            logger.error("\u3010IAM\u8c03\u7528\u3011\u83b7\u53d6\u79df\u6237\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            throw new BusinessException((ErrorHandler)I18nError.ERROR_10027);
        }
    }

    public GoodsStrategy getSellingStrategy(String goodsCode, String strategySid) {
        try {
            String url = this.envProperties.getGmcUri() + String.format("/api/cloudgoods/%s/sellingstrategys/%s", goodsCode, strategySid);
            HttpHeaders headers = new HttpHeaders();
            String token = UserUtils.getToken();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, token);
            GoodsStrategy result = (GoodsStrategy)this.dapRetryRestTemplate.getForObject(url, GoodsStrategy.class, (Map)headers);
            if (result != null) {
                return result;
            }
            logger.error("\u9500\u552e\u65b9\u6848{}\u4e0d\u5b58\u5728", (Object)strategySid);
            return null;
        }
        catch (Exception ex) {
            logger.error("\u83b7\u53d6\u9500\u552e\u65b9\u6848{}\u5931\u8d25", (Object)strategySid, (Object)ex);
            throw new BusinessException((ErrorHandler)I18nError.ERROR_10028, new Object[]{strategySid});
        }
    }

    public List<String> getIsvGoods(String isvTenantId) {
        String url = this.envProperties.getGmcUri() + "/api/gmc/v2/goods/dev/isv/option";
        HttpHeaders headers = new HttpHeaders();
        String token = UserUtils.getToken();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, token);
        HashMap<String, Object> requestParam = new HashMap<String, Object>();
        requestParam.put("servicerId", isvTenantId);
        requestParam.put("devIds", Collections.emptyList());
        HttpEntity requestEntity = new HttpEntity(requestParam, (MultiValueMap)headers);
        try {
            ResponseEntity responseResult = this.dapRetryRestTemplate.exchange(url, HttpMethod.POST, requestEntity, StdData.class, new Object[0]);
            if (responseResult.getBody() == null || 200 != ((StdData)responseResult.getBody()).getCode() || null == ((StdData)responseResult.getBody()).getData()) {
                logger.error(String.format("\u83b7\u53d6\u670d\u52a1\u5546\u6240\u5c5e\u5546\u54c1\u5931\u8d25,\u5931\u8d25\u539f\u56e0:%s", JsonUtils.writeValue((Object)responseResult.getBody())));
                throw new BusinessException((ErrorHandler)I18nError.ERROR_10029);
            }
            ObjectMapper objectMapper = JsonUtils.createObjectMapper();
            List result = (List)objectMapper.readValue(JsonUtils.writeValue((Object)((StdData)responseResult.getBody()).getData()), objectMapper.getTypeFactory().constructParametricType(List.class, new Class[]{GoodsStrategy.class}));
            return result.stream().map(GoodsStrategy::getCode).collect(Collectors.toList());
        }
        catch (Exception ex) {
            logger.error("\u83b7\u53d6\u670d\u52a1\u5546\u6240\u5c5e\u5546\u54c1\u5931\u8d25", (Throwable)ex);
            throw new BusinessException((ErrorHandler)I18nError.ERROR_10029);
        }
    }

    public Map<String, GoodsVO> getGoodsByGoodsIds(List<String> goodsCodes) {
        String url = this.envProperties.getGmcUri() + "/api/cloudgoods/detail";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put("goodsCodeList", goodsCodes);
        requestMap.put("pageSize", 9999);
        HttpEntity request = new HttpEntity(requestMap, (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.dapRetryRestTemplate.exchange(url, HttpMethod.POST, request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            List goodsVOS = Optional.ofNullable(responseEntity.getBody()).orElse(new ArrayList());
            return goodsVOS.stream().collect(Collectors.toMap(GoodsVO::getCode, Function.identity()));
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5546\u54c1\u4fe1\u606f\u5931\u8d25,goodsCodes:{}", goodsCodes, (Object)e);
            return new HashMap<String, GoodsVO>();
        }
    }

    public List<GoodsVO2> getGoodsSimpleInfoList(Map<String, Object> paramMap) {
        HttpHeaders headers = new HttpHeaders();
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        String url = this.envProperties.getGmcUri() + "/api/cloudgoods/simple/all" + "?updateErp={updateErp}";
        try {
            ResponseEntity response = this.dapRetryRestTemplate.exchange(url, HttpMethod.GET, request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, paramMap);
            return Optional.ofNullable(response.getBody()).map(StdData::getData).orElse(Collections.emptyList());
        }
        catch (Exception e) {
            logger.error("\u3010GMC\u3011 \u67e5\u8be2\u6240\u6709\u5546\u54c1\u7b80\u5355\u4fe1\u606f", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public List<GoodsVO> getGoodsByGoodsCodes(List<String> goodsCodeList) {
        HttpHeaders headers = new HttpHeaders();
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
        HashMap<String, List<String>> paramMap = new HashMap<String, List<String>>();
        paramMap.put("codes", goodsCodeList);
        HttpEntity request = new HttpEntity(paramMap, (MultiValueMap)headers);
        String url = this.envProperties.getGmcUri() + "/api/gmc/v2/goods/list";
        try {
            ResponseEntity response = this.dapRetryRestTemplate.exchange(url, HttpMethod.POST, request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return Optional.ofNullable(response.getBody()).map(StdData::getData).orElse(Collections.emptyList());
        }
        catch (Exception e) {
            logger.error("\u3010GMC\u3011 \u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public List<GoodsVO> getPackDetail(String packCode) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("id", packCode);
        HttpHeaders headers = new HttpHeaders();
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        String url = this.envProperties.getGmcUri() + "/api/gmc/v2/pack/id" + "?id={id}";
        try {
            ResponseEntity response = this.dapRetryRestTemplate.exchange(url, HttpMethod.GET, request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, paramMap);
            return Optional.ofNullable(response.getBody()).map(StdData::getData).orElse(Collections.emptyList());
        }
        catch (Exception e) {
            logger.error("\u3010GMC\u3011 \u67e5\u8be2\u6240\u6709\u5546\u54c1\u7b80\u5355\u4fe1\u606f", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public List<MarketingConfigDetailVO> getPlatFormGoodsInfo(String tenantId, String goodsCode) {
        String url = String.format("%s%s?types=0&types=2&goodsCodeEq=%s", this.envProperties.getGmcUri(), "/api/gmc/v2/marketing/search", goodsCode);
        HttpHeaders headers = new HttpHeaders();
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, StringUtils.hasText((String)UserUtils.getToken()) ? UserUtils.getToken() : this.dapHttpService.getUserToken(tenantId));
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity response = this.dapRetryRestTemplate.exchange(url, HttpMethod.GET, request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            PageSerializable goodsInfo = Optional.ofNullable(response.getBody()).map(StdData::getData).orElse(null);
            if (null != goodsInfo && !CollectionUtils.isEmpty((Collection)goodsInfo.getList())) {
                return ((GoodsMarketConfig)goodsInfo.getList().get(0)).getDetails();
            }
        }
        catch (Exception e) {
            logger.error("\u3010GMC\u3011 \u67e5\u8be2\u5546\u54c1\u7684\u76f8\u4f9d\u6027\u5546\u54c1\u5931\u8d25", (Throwable)e);
        }
        return Collections.emptyList();
    }
}

