/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.support.remote.impl;

import com.digiwin.dap.middleware.cac.constant.I18nError;
import com.digiwin.dap.middleware.cac.domain.CommonVO;
import com.digiwin.dap.middleware.cac.domain.DevSysVO;
import com.digiwin.dap.middleware.cac.domain.EnvProperties;
import com.digiwin.dap.middleware.cac.domain.PurchaseUserCountInfoVO;
import com.digiwin.dap.middleware.cac.domain.remote.IamUser;
import com.digiwin.dap.middleware.cac.domain.remote.SysVO;
import com.digiwin.dap.middleware.cac.domain.remote.TenantInfo;
import com.digiwin.dap.middleware.cac.domain.remote.TenantSimpleVO;
import com.digiwin.dap.middleware.cac.domain.remote.UserInTenantVO;
import com.digiwin.dap.middleware.cac.support.remote.IamService;
import com.digiwin.dap.middleware.constant.GlobalConstants;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.support.DapHttpService;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.pagehelper.PageSerializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class IamServiceImpl
implements IamService {
    private static final Logger logger = LoggerFactory.getLogger(IamServiceImpl.class);
    private static final String DEFAULT_DIGIWIN_TENANT_ID = "99990000";
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private DapHttpService dapHttpService;
    @Resource(name="dapRetryRestTemplate")
    private RestTemplate dapRetryRestTemplate;

    public List<String> getTenantIdsByAppId(String appId) {
        if (StringUtils.isEmpty((Object)appId)) {
            throw new IllegalArgumentException(I18nError.ERROR_10007.getErrorMessage());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, StringUtils.hasText((String)UserUtils.getToken()) ? UserUtils.getToken() : this.dapHttpService.getUserToken(DEFAULT_DIGIWIN_TENANT_ID));
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        try {
            String url = this.envProperties.getIamUri() + "/api/iam/v2/tenant/simple/app/" + appId;
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, request, List.class, new Object[0]);
            if (null == responseEntity || null == responseEntity.getBody()) {
                throw new BusinessException("\u83b7\u53d6\u5e94\u7528\u79df\u6237\u6e05\u5355\u4e3anull");
            }
            return (List)responseEntity.getBody();
        }
        catch (Exception e) {
            logger.error("\u6839\u64daappId\u7372\u53d6\u79df\u6236id\u7570\u5e38", (Throwable)e);
            throw new BusinessException((ErrorHandler)I18nError.ERROR_10030);
        }
    }

    public Map<String, Long> getTenantSid(List<String> tenantIds) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity request = new HttpEntity(tenantIds, (MultiValueMap)headers);
            String url = this.envProperties.getIamUri() + "/api/iam/v2/tenant/sid";
            ResponseEntity responseEntity = this.dapRetryRestTemplate.exchange(url, HttpMethod.POST, request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return (Map)responseEntity.getBody();
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u79df\u6237Sid\u5931\u8d25", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    public Map getRowPermission(String userToken, int type) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
            HashMap<String, String> requestContent = new HashMap<String, String>(3);
            if (2 == type) {
                requestContent.put("sysId", "boss");
                requestContent.put("moduleId", "boss-customer");
                requestContent.put("actionId", "boss-api-product-subscribe");
            } else {
                requestContent.put("sysId", "boss");
                requestContent.put("moduleId", "boss-goods");
                requestContent.put("actionId", "boss-goods-management");
            }
            HttpEntity request = new HttpEntity(requestContent, (MultiValueMap)headers);
            String url = this.envProperties.getIamUri() + "/api/iam/v2/permission/data/row";
            ResponseEntity responseEntity = this.dapRetryRestTemplate.postForEntity(url, (Object)request, Map.class, new Object[0]);
            return (Map)responseEntity.getBody();
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6570\u636e\u6743\u9650\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public List<PurchaseUserCountInfoVO> getUserDetails(List<UserInTenantVO> userIds, String userToken) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
            HttpEntity request = new HttpEntity(userIds, (MultiValueMap)headers);
            String url = this.envProperties.getIamUri() + "/api/iam/v2/user/auth/user/detail";
            StdData responseEntity = (StdData)this.dapRetryRestTemplate.postForObject(url, (Object)request, StdData.class, new Object[0]);
            if (responseEntity != null && responseEntity.getData() != null) {
                List resultData = (List)new ObjectMapper().convertValue(responseEntity.getData(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                return resultData;
            }
            return null;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6570\u636e\u6743\u9650\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public List<String> getWhiteList(String id) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.set(GlobalConstants.HTTP_HEADER_APP_TOKEN_KEY, "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpYXQiOjE0OTM4OTc3MjI0MTEsInNpZCI6ODIyMDIzMzgxOTg0NjE5NjUwLCJpZCI6ImNvcmVtaWRkbGV3YXJlIn0.DMSIMMmwi5qrq7niOl80nU5VbXjFWlgmclTn2cEiORo");
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, StringUtils.isEmpty((Object)UserUtils.getToken()) ? this.dapHttpService.getUserToken(DEFAULT_DIGIWIN_TENANT_ID) : UserUtils.getToken());
            HashMap<String, String> body = new HashMap<String, String>();
            body.put("id", id);
            HttpEntity requestBody = new HttpEntity(body, (MultiValueMap)headers);
            String url = this.envProperties.getIamUri() + "/api/iam/v2/white/list";
            return (List)this.dapRetryRestTemplate.postForObject(url, (Object)requestBody, List.class, new Object[0]);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5e94\u7528ID\u5931\u8d25:{}", (Object)e.getMessage());
            return Collections.emptyList();
        }
    }

    public List<TenantInfo> getTenantInfos(List<String> tenantIds, Boolean test, Boolean withTax) {
        try {
            StdData body;
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.set(GlobalConstants.HTTP_HEADER_APP_TOKEN_KEY, "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpYXQiOjE0OTM4OTc3MjI0MTEsInNpZCI6ODIyMDIzMzgxOTg0NjE5NjUwLCJpZCI6ImNvcmVtaWRkbGV3YXJlIn0.DMSIMMmwi5qrq7niOl80nU5VbXjFWlgmclTn2cEiORo");
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, StringUtils.isEmpty((Object)UserUtils.getToken()) ? this.dapHttpService.getUserToken(DEFAULT_DIGIWIN_TENANT_ID) : UserUtils.getToken());
            HashMap<String, Object> requestParam = new HashMap<String, Object>();
            requestParam.put("tenantIds", tenantIds);
            requestParam.put("testTenant", test);
            requestParam.put("withTax", withTax);
            HttpEntity request = new HttpEntity(requestParam, (MultiValueMap)headers);
            String url = this.envProperties.getIamUri() + "/api/iam/v2/tenant/getname/list/info";
            ResponseEntity responseEntity = this.dapRetryRestTemplate.exchange(url, HttpMethod.POST, request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            if (responseEntity != null && (body = (StdData)responseEntity.getBody()) != null) {
                ObjectMapper objectMapper = JsonUtils.createObjectMapper();
                List result = (List)objectMapper.readValue(JsonUtils.writeValue((Object)body.getData()), objectMapper.getTypeFactory().constructParametricType(List.class, new Class[]{TenantInfo.class}));
                return result;
            }
            return Collections.emptyList();
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6307\u5b9a\u79df\u6237\u7684\u6027\u8d28(\u6d4b\u8bd5/\u4e00\u822c)\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public List<TenantSimpleVO> getALlAthenaTenants() {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.set(GlobalConstants.HTTP_HEADER_APP_TOKEN_KEY, "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpYXQiOjE0OTM4OTc3MjI0MTEsInNpZCI6ODIyMDIzMzgxOTg0NjE5NjUwLCJpZCI6ImNvcmVtaWRkbGV3YXJlIn0.DMSIMMmwi5qrq7niOl80nU5VbXjFWlgmclTn2cEiORo");
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, StringUtils.isEmpty((Object)UserUtils.getToken()) ? this.dapHttpService.getUserToken(DEFAULT_DIGIWIN_TENANT_ID) : UserUtils.getToken());
            HashMap requestParam = new HashMap();
            HttpEntity request = new HttpEntity(requestParam, (MultiValueMap)headers);
            String url = this.envProperties.getIamUri() + "/api/iam/v2/tenant/app/tenants";
            ResponseEntity responseEntity = this.dapRetryRestTemplate.exchange(url, HttpMethod.POST, request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return Optional.of(responseEntity).map(HttpEntity::getBody).map(StdData::getData).orElse(new ArrayList());
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6307\u5b9a\u79df\u6237\u7684\u6027\u8d28(\u6d4b\u8bd5/\u4e00\u822c)\u5931\u8d25", (Throwable)e);
            return new ArrayList<TenantSimpleVO>();
        }
    }

    public List<String> getTestTenantIds() {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            HttpEntity request = new HttpEntity((MultiValueMap)headers);
            String url = this.envProperties.getIamUri() + "/api/iam/v2/tenant/test/ids";
            ResponseEntity result = this.dapRetryRestTemplate.exchange(url, HttpMethod.GET, request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return Optional.ofNullable(result).map(HttpEntity::getBody).map(StdData::getData).orElse(new ArrayList());
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u79df\u6237\u6388\u6743\u7801\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            return new ArrayList<String>();
        }
    }

    public Boolean checkAccessPermission(String method, String path, String targetType) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            HashMap<String, String> requestData = new HashMap<String, String>();
            requestData.put("targetType", targetType);
            requestData.put("method", method);
            requestData.put("path", path);
            requestData.put("targetId", UserUtils.getSysId());
            HttpEntity request = new HttpEntity(requestData, (MultiValueMap)headers);
            String url = this.envProperties.getIamUri() + "/api/iam/v2/ram/access/check";
            ResponseEntity result = this.dapRetryRestTemplate.exchange(url, HttpMethod.POST, request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return Optional.ofNullable(result).map(HttpEntity::getBody).orElse(false);
        }
        catch (Exception e) {
            logger.error("\u68c0\u67e5\u63a5\u53e3\u8bbf\u95ee\u6743\u9650\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    public Boolean checkSuperAdmin() {
        try {
            IamUser iamUser;
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            HashMap<String, String> requestData = new HashMap<String, String>();
            requestData.put("id", UserUtils.getUserId());
            HttpEntity request = new HttpEntity(requestData, (MultiValueMap)headers);
            String url = this.envProperties.getIamUri() + "/api/iam/v2/user/role";
            ResponseEntity result = this.dapRetryRestTemplate.exchange(url, HttpMethod.POST, request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            if (Optional.ofNullable(result).isPresent() && null != (iamUser = (IamUser)Optional.ofNullable(result).get().getBody()) && !CollectionUtils.isEmpty((Collection)iamUser.getRoles()) && iamUser.getRoles().stream().anyMatch(r -> "superadmin".equalsIgnoreCase(r.getId()))) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error("\u68c0\u67e5\u63a5\u53e3\u8bbf\u95ee\u6743\u9650\u5931\u8d25", (Throwable)e);
        }
        return false;
    }

    public List<TenantInfo> getAllTenantUserCountExcludeTest(List<String> allTenantIds) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.set(GlobalConstants.HTTP_HEADER_APP_TOKEN_KEY, "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpYXQiOjE0OTM4OTc3MjI0MTEsInNpZCI6ODIyMDIzMzgxOTg0NjE5NjUwLCJpZCI6ImNvcmVtaWRkbGV3YXJlIn0.DMSIMMmwi5qrq7niOl80nU5VbXjFWlgmclTn2cEiORo");
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, StringUtils.isEmpty((Object)UserUtils.getToken()) ? this.dapHttpService.getUserToken(DEFAULT_DIGIWIN_TENANT_ID) : UserUtils.getToken());
            HttpEntity request = new HttpEntity(allTenantIds, (MultiValueMap)headers);
            String url = this.envProperties.getIamUri() + "/api/iam/v2/tenant/count";
            ResponseEntity responseEntity = this.dapRetryRestTemplate.exchange(url, HttpMethod.POST, request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return Optional.of(responseEntity).map(HttpEntity::getBody).map(StdData::getData).orElse(new ArrayList());
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2iam\u79df\u6237\u5931\u8d25", (Throwable)e);
            throw new BusinessException("\u67e5\u8be2iam\u79df\u6237\u5931\u8d25\uff01");
        }
    }

    public List<SysVO> getPlatformInfos(String tenantId, List<String> sysIds) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.set(GlobalConstants.HTTP_HEADER_APP_TOKEN_KEY, "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpYXQiOjE0OTM4OTc3MjI0MTEsInNpZCI6ODIyMDIzMzgxOTg0NjE5NjUwLCJpZCI6ImNvcmVtaWRkbGV3YXJlIn0.DMSIMMmwi5qrq7niOl80nU5VbXjFWlgmclTn2cEiORo");
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, ObjectUtils.isEmpty((Object)UserUtils.getToken()) ? this.dapHttpService.getUserToken(tenantId) : UserUtils.getToken());
            HashMap<String, List<String>> param = new HashMap<String, List<String>>();
            param.put("appIds", sysIds);
            HttpEntity request = new HttpEntity(param, (MultiValueMap)headers);
            String url = this.envProperties.getIamUri() + "/api/iam/v2/sys/platform/all/ids";
            ResponseEntity responseEntity = this.dapRetryRestTemplate.exchange(url, HttpMethod.POST, request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            logger.info("\u67e5\u8be2\u5e94\u7528\u5173\u8054\u5e73\u53f0\u5e94\u7528\u4fe1\u606f:{}", (Object)responseEntity);
            return Optional.of(responseEntity).map(HttpEntity::getBody).map(StdData::getData).orElse(new ArrayList());
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5e94\u7528\u5173\u8054\u5e73\u53f0\u5e94\u7528\u5931\u8d25", (Throwable)e);
            return new ArrayList<SysVO>();
        }
    }

    public List<String> getDevSys(String tenantId) {
        if (ObjectUtils.isEmpty((Object)tenantId)) {
            return new ArrayList<String>();
        }
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.set(GlobalConstants.HTTP_HEADER_APP_TOKEN_KEY, "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpYXQiOjE0OTM4OTc3MjI0MTEsInNpZCI6ODIyMDIzMzgxOTg0NjE5NjUwLCJpZCI6ImNvcmVtaWRkbGV3YXJlIn0.DMSIMMmwi5qrq7niOl80nU5VbXjFWlgmclTn2cEiORo");
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, ObjectUtils.isEmpty((Object)UserUtils.getToken()) ? this.dapHttpService.getUserToken(tenantId) : UserUtils.getToken());
            HttpEntity request = new HttpEntity((MultiValueMap)headers);
            String url = this.envProperties.getIamUri() + "/api/iam/v2/dev/app/tenant/id" + "?tenantId=" + tenantId;
            ResponseEntity responseEntity = this.dapRetryRestTemplate.exchange(url, HttpMethod.GET, request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return Optional.of(responseEntity).map(HttpEntity::getBody).map(StdData::getData).orElse(new ArrayList());
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2iam\u5f00\u53d1\u5546\u5e94\u7528\u5931\u8d25", (Throwable)e);
            return new ArrayList<String>();
        }
    }

    public List<CommonVO> getTenantSimples(Collection<String> tenantIds) {
        try {
            if (CollectionUtils.isEmpty(tenantIds)) {
                return Collections.emptyList();
            }
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            String userToken = this.dapHttpService.getUserToken(DEFAULT_DIGIWIN_TENANT_ID);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
            HttpEntity request = new HttpEntity(tenantIds, (MultiValueMap)headers);
            String url = this.envProperties.getIamUri() + "/api/iam/v2/tenant/simples";
            ResponseEntity response = this.dapRetryRestTemplate.exchange(url, HttpMethod.POST, request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return (List)response.getBody();
        }
        catch (Exception e) {
            logger.error("\u3010IAM\u8c03\u7528\u3011\u83b7\u53d6\u79df\u6237\u7b80\u5355\u4fe1\u606f\u9519\u8bef", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public List<DevSysVO> getDevSysList(List<String> appIdList) {
        try {
            if (CollectionUtils.isEmpty(appIdList)) {
                return Collections.emptyList();
            }
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            String userToken = this.dapHttpService.getUserToken(DEFAULT_DIGIWIN_TENANT_ID);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("ids", appIdList);
            param.put("pageNum", 1);
            param.put("pageSize", appIdList.size());
            param.put("orderBy", "sid");
            HttpEntity request = new HttpEntity(param, (MultiValueMap)headers);
            String url = this.envProperties.getIamUri() + "/api/iam/v2/dev/app/list";
            ResponseEntity response = this.dapRetryRestTemplate.exchange(url, HttpMethod.POST, request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return Optional.of(response).map(HttpEntity::getBody).map(StdData::getData).map(PageSerializable::getList).orElse(new ArrayList());
        }
        catch (Exception e) {
            logger.error("\u3010IAM\u8c03\u7528\u3011\u83b7\u53d6DevSys\u9519\u8bef", (Throwable)e);
            return Collections.emptyList();
        }
    }
}

