/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.support.remote.impl;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.cac.domain.CloudPurchaseDTO;
import com.digiwin.dap.middleware.cac.domain.EnabledModuleDTO;
import com.digiwin.dap.middleware.cac.domain.EnvProperties;
import com.digiwin.dap.middleware.cac.domain.remote.BatchAuthModuleLogVO;
import com.digiwin.dap.middleware.cac.domain.remote.ChangeInfoList;
import com.digiwin.dap.middleware.cac.domain.remote.ChangedSet;
import com.digiwin.dap.middleware.cac.domain.remote.InsertInfo;
import com.digiwin.dap.middleware.cac.domain.remote.OpLogVO;
import com.digiwin.dap.middleware.cac.entity.Purchase;
import com.digiwin.dap.middleware.cac.entity.UserInCounting;
import com.digiwin.dap.middleware.cac.support.remote.LmcService;
import com.digiwin.dap.middleware.constant.GlobalConstants;
import com.digiwin.dap.middleware.lmc.request.SaveCompareOpLog;
import com.digiwin.dap.middleware.support.DapHttpService;
import com.digiwin.dap.middleware.util.ExceptionUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class LmcServiceImpl
implements LmcService {
    private static final Logger logger = LoggerFactory.getLogger(LmcServiceImpl.class);
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private DapHttpService dapHttpService;
    @Qualifier(value="dapLogExecutor")
    @Autowired
    private ThreadPoolTaskExecutor dapLogExecutor;

    public void saveBatchAuthMoudleLog(BatchAuthModuleLogVO batchAuthModuleLogVO, String userToken) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", userToken);
        HttpEntity request = new HttpEntity((Object)batchAuthModuleLogVO, (MultiValueMap)headers);
        String url = this.envProperties.getLmcUri() + "/api/lmc/v1/buckets/digiwincloud/changelogs/result";
        this.dapLogExecutor.execute(() -> this.restTemplate.postForEntity(url, (Object)request, Object.class, new Object[0]));
    }

    public void saveBatchAuthMoudleLog(List<CloudPurchaseDTO> cloudPurchaseDTOList) {
        AuthoredUser user = UserUtils.getAuthoredUser();
        try {
            for (int i = 0; i < cloudPurchaseDTOList.size(); ++i) {
                CloudPurchaseDTO cloudPurchaseDTO = cloudPurchaseDTOList.get(i);
                BatchAuthModuleLogVO batchAuthModuleLogVO = new BatchAuthModuleLogVO();
                batchAuthModuleLogVO.setEditUserId(user.getUserId());
                batchAuthModuleLogVO.setEditUserName(user.getUserName());
                batchAuthModuleLogVO.setSource("CAC");
                batchAuthModuleLogVO.setActionId("update");
                batchAuthModuleLogVO.setPrimaryKey(cloudPurchaseDTO.getPurchaseId());
                batchAuthModuleLogVO.setTableName("purchase");
                batchAuthModuleLogVO.setRemark("\u6279\u91cf\u6388\u6743\u6a21\u7ec4\u53d8\u66f4");
                ArrayList<ChangeInfoList> changeInfoList = new ArrayList<ChangeInfoList>();
                ChangeInfoList changeInfoListVO = new ChangeInfoList();
                changeInfoListVO.setKey("enabledModules");
                changeInfoListVO.setType("collectionProperty");
                ArrayList<ChangedSet> changedSetList = new ArrayList<ChangedSet>();
                ChangedSet changedSet = new ChangedSet();
                changedSet.setChangeType("insert");
                for (int j = 0; j < cloudPurchaseDTO.getModules().size(); ++j) {
                    EnabledModuleDTO enabledModuleDTO = (EnabledModuleDTO)cloudPurchaseDTO.getModules().get(j);
                    changedSet.setPrimaryKey(enabledModuleDTO.getId());
                    changedSet.setDisplayName(enabledModuleDTO.getName());
                    InsertInfo insertInfo = new InsertInfo();
                    insertInfo.setName(enabledModuleDTO.getName());
                    insertInfo.setId(enabledModuleDTO.getId());
                    insertInfo.setExpiredTime(enabledModuleDTO.getExpiredTime());
                    changedSet.setInsertInfo(insertInfo);
                }
                changedSetList.add(changedSet);
                changeInfoListVO.setChangedSet(changedSetList);
                changeInfoList.add(changeInfoListVO);
                batchAuthModuleLogVO.setChangeInfoList(changeInfoList);
                changeInfoListVO.setChangedSet(changedSetList);
                batchAuthModuleLogVO.setChangeInfoList(changeInfoList);
                this.saveBatchAuthMoudleLog(batchAuthModuleLogVO, user.getToken());
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void saveCompareOpLog(SaveCompareOpLog dto, String userToken, String tenantId) {
        if (StringUtils.isEmpty((Object)this.envProperties.getLmcUri())) {
            logger.error("\u3010LMC\u8c03\u7528\u3011 \u4fdd\u5b58\u53d8\u66f4\u5386\u7a0b\u5931\u8d25\uff0cLMC URL \u4e3a\u7a7a");
            return;
        }
        if (StringUtils.isEmpty((Object)userToken)) {
            userToken = this.dapHttpService.getUserToken(tenantId);
        }
        String url = this.envProperties.getLmcUri() + "/api/lmc/v1/oplog/compare/direct";
        if (StringUtils.isEmpty((Object)dto.getAppId())) {
            dto.setAppId("digiwincloud");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("Accept", "application/json;charset=UTF-8");
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
        HttpEntity logRequest = new HttpEntity((Object)dto, (MultiValueMap)headers);
        this.dapLogExecutor.execute(() -> {
            try {
                this.restTemplate.postForEntity(url, (Object)logRequest, Object.class, new Object[0]);
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.logError((String)"\u3010LMC\u8c03\u7528\u3011 \u4fdd\u5b58\u53d8\u66f4\u5386\u7a0b\u5931\u8d25", (String)url, (Object)logRequest.getBody(), (Exception)e), (Throwable)e);
            }
        });
    }

    public void saveCleanUser(Purchase purchase, List<UserInCounting> userInCountings, String tenantId, String reamrk) {
        OpLogVO vo = new OpLogVO();
        vo.setAppId("digiwincloud");
        vo.setModuleId("djc-mang-user");
        vo.setActionId("tenant.authorizedUserChangeLog");
        vo.setActId("action_authorization");
        vo.setEditPlace("console");
        vo.setEditUserId("system");
        vo.setEditUserName("system");
        vo.setOperationType("delete");
        vo.setSource("iam");
        vo.setOperationObject(purchase.getProductName());
        vo.setPrimaryKey(purchase.getProductCode());
        vo.setPrimaryName(purchase.getProductName());
        vo.setTenantId(purchase.getCustomerId());
        vo.setRemark(reamrk);
        ChangeInfoList changeInfoList = new ChangeInfoList();
        vo.setChangeInfoList(Collections.singletonList(changeInfoList));
        changeInfoList.setOriginValue(userInCountings.stream().map(UserInCounting::getUserId).collect(Collectors.joining(",")));
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, ObjectUtils.isEmpty((Object)UserUtils.getToken()) ? this.dapHttpService.getUserToken(tenantId) : UserUtils.getToken());
        HttpEntity request = new HttpEntity((Object)vo, (MultiValueMap)headers);
        String url = this.envProperties.getLmcUri() + "/api/lmc/v1/oplog";
        this.dapLogExecutor.execute(() -> this.restTemplate.postForEntity(url, (Object)request, Object.class, new Object[0]));
    }
}

