/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.support.remote.impl;

import com.digiwin.dap.middle.stream.domain.MessageBody;
import com.digiwin.dap.middle.stream.producer.ProducerService;
import com.digiwin.dap.middleware.cac.domain.EnabledModuleDTO;
import com.digiwin.dap.middleware.cac.domain.GoodsExpireVO;
import com.digiwin.dap.middleware.cac.domain.enumeration.MailTypeEnum;
import com.digiwin.dap.middleware.cac.domain.remote.AuthorizationExpiredTimeMessageInfo;
import com.digiwin.dap.middleware.cac.domain.remote.AuthorizationModuleMessageInfo;
import com.digiwin.dap.middleware.cac.entity.Customer;
import com.digiwin.dap.middleware.cac.entity.PurchaseModule;
import com.digiwin.dap.middleware.cac.service.basic.CustomerCrudService;
import com.digiwin.dap.middleware.cac.support.remote.MailService;
import java.time.LocalDateTime;
import java.util.List;
import org.apache.tomcat.util.buf.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MailServiceImpl
implements MailService {
    private static final Logger logger = LoggerFactory.getLogger(MailServiceImpl.class);
    @Autowired
    private ProducerService producerService;
    @Autowired
    private CustomerCrudService customerCrudService;

    public void sendBatchAuthorizationModule(String goodsName, List<PurchaseModule> modules, String tenantId) {
        try {
            Customer customer = this.customerCrudService.findById(tenantId);
            AuthorizationModuleMessageInfo authorizationModuleMessageInfo = new AuthorizationModuleMessageInfo();
            authorizationModuleMessageInfo.setAppName(goodsName);
            authorizationModuleMessageInfo.setModules(modules);
            authorizationModuleMessageInfo.setTenantId(tenantId);
            authorizationModuleMessageInfo.setTenantName(customer.getName());
            MessageBody cacMessage = new MessageBody();
            cacMessage.setOpType("CAC_AUTHORIZATION_MODULE");
            cacMessage.setData((Object)authorizationModuleMessageInfo);
            this.producerService.msg(cacMessage);
        }
        catch (Exception e) {
            logger.error(String.format("\u53d1\u9001\u6279\u91cf\u901a\u77e5\u6dfb\u52a0\u6a21\u7ec4\u90ae\u4ef6\u5931\u8d25,\u5546\u54c1\u540d\u79f0[%s]", goodsName), (Throwable)e);
        }
    }

    public void sendChangeAuthorizationExpiredTime(String productName, LocalDateTime oldExpiredTime, LocalDateTime expiredTime, List<String> emails, Boolean currentTenant, String tenantId, String tenantName, List<EnabledModuleDTO> modules) {
        try {
            AuthorizationExpiredTimeMessageInfo authorizationExpiredTimeMessageInfo = new AuthorizationExpiredTimeMessageInfo();
            authorizationExpiredTimeMessageInfo.setAppName(productName);
            authorizationExpiredTimeMessageInfo.setOldExpiredTime(oldExpiredTime);
            authorizationExpiredTimeMessageInfo.setExpiredTime(expiredTime);
            authorizationExpiredTimeMessageInfo.setEmail(StringUtils.join(emails, (char)';'));
            authorizationExpiredTimeMessageInfo.setCustomerId(tenantId);
            authorizationExpiredTimeMessageInfo.setCustomerName(tenantName);
            authorizationExpiredTimeMessageInfo.setModules(modules);
            if (currentTenant.booleanValue()) {
                authorizationExpiredTimeMessageInfo.setTenantId(tenantId);
            }
            MessageBody cacMessage = new MessageBody();
            cacMessage.setOpType("CAC_EXPIRED_TIME_CHANGE");
            cacMessage.setData((Object)authorizationExpiredTimeMessageInfo);
            this.producerService.msg(cacMessage);
        }
        catch (Exception e) {
            logger.error(String.format("\u53d1\u9001\u6388\u6743\u5230\u671f\u65e5\u5f02\u52a8\u901a\u77e5\u90ae\u4ef6\u5931\u8d25,\u5546\u54c1\u540d\u79f0[%s]", productName), (Throwable)e);
        }
    }

    public void sendExpiredNotice(List<GoodsExpireVO> goodsExpireVOS) {
        try {
            MessageBody messageBody = new MessageBody();
            messageBody.setOpType(MailTypeEnum.CAC_RESOURCE_APP_AUTH_EXPIRED.name());
            goodsExpireVOS.forEach(t -> {
                messageBody.setData(t);
                this.producerService.msg(messageBody);
            });
        }
        catch (Exception ex) {
            logger.error("\u53d1\u9001\u8ba1\u91cf\u5546\u54c1\u6570\u91cf\u5230\u671f\u901a\u77e5", (Throwable)ex);
        }
    }
}

