/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.support.remote.impl;

import com.digiwin.dap.middleware.cac.constant.I18nError;
import com.digiwin.dap.middleware.cac.domain.EnvProperties;
import com.digiwin.dap.middleware.cac.domain.OrderCloudDeviceVO;
import com.digiwin.dap.middleware.cac.domain.remote.GoodsAuthDO;
import com.digiwin.dap.middleware.cac.support.remote.OmcService;
import com.digiwin.dap.middleware.constant.GlobalConstants;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import com.github.pagehelper.PageSerializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class OmcServiceImpl
implements OmcService {
    private static final Logger logger = LoggerFactory.getLogger(OmcServiceImpl.class);
    @Resource
    private EnvProperties envProperties;
    @Resource
    private RestTemplate restTemplate;
    @Resource(name="dapRetryRestTemplate")
    private RestTemplate dapRetryRestTemplate;

    public void purchaseApp(List<GoodsAuthDO> goodsAuthDOList) {
        String uri = this.envProperties.getOmcUri() + "/api/omc/v2/sys/authorization";
        String json = JsonUtils.writeValue(goodsAuthDOList);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
        HttpEntity request = new HttpEntity((Object)json, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(uri, (Object)request, StdData.class, new Object[0]);
        if (null == response.getBody()) {
            logger.error("\u5f00\u901a\u6388\u6743\u4ee5\u53ca\u521d\u59cb\u5316\u5931\u8d25");
            throw new BusinessException((ErrorHandler)I18nError.ORDER_ADD_AUTH_FAIL);
        }
    }

    public List<OrderCloudDeviceVO> findDeviceByOrderCode(String orderCode) {
        String url = this.envProperties.getOmcUri() + "/api/omc/v2/device/cloud/backend/search";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put("orderCode", orderCode);
        requestMap.put("pageSize", 9999);
        HttpEntity request = new HttpEntity(requestMap, (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.dapRetryRestTemplate.exchange(url, HttpMethod.POST, request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return Optional.ofNullable(responseEntity.getBody()).map(StdData::getData).map(PageSerializable::getList).orElseGet(Collections::emptyList);
        }
        catch (Exception e) {
            logger.error("\u3010OMC\u8c03\u7528\u3011\u83b7\u53d6\u4e91\u8d44\u6e90\u5931\u8d25", (Throwable)e);
            return new ArrayList<OrderCloudDeviceVO>();
        }
    }
}

