/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.support.schedule.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.util.StrUtil;
import com.digiwin.dap.middle.cache.lock.CacheLock;
import com.digiwin.dap.middle.stream.domain.MessageBody;
import com.digiwin.dap.middle.stream.domain.SysNoticeEnum;
import com.digiwin.dap.middle.stream.producer.ProducerService;
import com.digiwin.dap.middleware.cac.constant.DecreaseLogEnum;
import com.digiwin.dap.middleware.cac.constant.DecreaseLogOperationTypeEnum;
import com.digiwin.dap.middleware.cac.domain.CloudPurchaseDTO;
import com.digiwin.dap.middleware.cac.domain.EnvProperties;
import com.digiwin.dap.middleware.cac.domain.GoodsExpireVO;
import com.digiwin.dap.middleware.cac.domain.OverUseVO;
import com.digiwin.dap.middleware.cac.domain.PurchaseCountLogVO;
import com.digiwin.dap.middleware.cac.domain.TenantPurchaseExpiredVO;
import com.digiwin.dap.middleware.cac.domain.UsageAlertDetailVO;
import com.digiwin.dap.middleware.cac.domain.UsageAlertVO;
import com.digiwin.dap.middleware.cac.domain.UserInCountingVO;
import com.digiwin.dap.middleware.cac.domain.enumeration.GoodsCategoryEnum;
import com.digiwin.dap.middleware.cac.domain.enumeration.Operate;
import com.digiwin.dap.middleware.cac.domain.remote.GoodsVO;
import com.digiwin.dap.middleware.cac.domain.remote.PaymentTypeVO;
import com.digiwin.dap.middleware.cac.domain.remote.TenantInfo;
import com.digiwin.dap.middleware.cac.entity.Customer;
import com.digiwin.dap.middleware.cac.entity.DecreaseLog;
import com.digiwin.dap.middleware.cac.entity.Purchase;
import com.digiwin.dap.middleware.cac.entity.PurchaseCount;
import com.digiwin.dap.middleware.cac.entity.PurchaseCountLog;
import com.digiwin.dap.middleware.cac.entity.PurchaseSnapshot;
import com.digiwin.dap.middleware.cac.entity.PurchaseSnapshotByLine;
import com.digiwin.dap.middleware.cac.entity.PurchaseSnapshotByProduct;
import com.digiwin.dap.middleware.cac.entity.Record;
import com.digiwin.dap.middleware.cac.entity.UserInCounting;
import com.digiwin.dap.middleware.cac.mapper.PurchaseCountMapper;
import com.digiwin.dap.middleware.cac.mapper.PurchaseMapper;
import com.digiwin.dap.middleware.cac.repository.PurchaseCountLogRepository;
import com.digiwin.dap.middleware.cac.repository.PurchaseSnapshotByLineRepository;
import com.digiwin.dap.middleware.cac.repository.PurchaseSnapshotByProductRepository;
import com.digiwin.dap.middleware.cac.repository.PurchaseSnapshotRepository;
import com.digiwin.dap.middleware.cac.service.basic.CustomerCrudService;
import com.digiwin.dap.middleware.cac.service.basic.DecreaseLogCrudService;
import com.digiwin.dap.middleware.cac.service.basic.PurchaseCountCrudService;
import com.digiwin.dap.middleware.cac.service.basic.PurchaseCrudService;
import com.digiwin.dap.middleware.cac.service.basic.RecordCrudService;
import com.digiwin.dap.middleware.cac.service.basic.UserInCountingCrudService;
import com.digiwin.dap.middleware.cac.service.business.PurchaseCountService;
import com.digiwin.dap.middleware.cac.service.business.StatisticInvokeLogService;
import com.digiwin.dap.middleware.cac.support.remote.GmcService;
import com.digiwin.dap.middleware.cac.support.remote.IamService;
import com.digiwin.dap.middleware.cac.support.remote.LmcService;
import com.digiwin.dap.middleware.cac.support.remote.MailService;
import com.digiwin.dap.middleware.cac.support.schedule.ScheduleTaskService;
import com.digiwin.dap.middleware.cac.support.schedule.impl.ScheduleTaskServiceImpl;
import com.digiwin.dap.middleware.cac.util.TransactionUtil;
import com.digiwin.dap.middleware.cac.util.UserIdUtil;
import com.digiwin.dap.middleware.cache.RedisUtils;
import com.digiwin.dap.middleware.domain.DeployAreaEnum;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ScheduleTaskServiceImpl
implements ScheduleTaskService {
    private static List<Long> numbers = Arrays.asList(1L, 2L, 3L, 7L, 30L);
    private static final Logger logger = LoggerFactory.getLogger(ScheduleTaskServiceImpl.class);
    @Autowired
    private IamService iamService;
    @Autowired
    private GmcService gmcService;
    @Autowired
    private PurchaseMapper purchaseMapper;
    @Autowired
    private ProducerService producerService;
    @Autowired
    private PurchaseCountCrudService purchaseCountCrudService;
    @Autowired
    private RecordCrudService recordCrudService;
    @Autowired
    private PurchaseCrudService purchaseCrudService;
    @Autowired
    private CustomerCrudService customerCrudService;
    @Autowired
    private PurchaseCountLogRepository purchaseCountLogRepository;
    @Autowired
    private UserInCountingCrudService userInCountingCrudService;
    @Autowired
    private LmcService lmcService;
    @Autowired
    private TransactionUtil transactionUtil;
    @Autowired
    private PurchaseSnapshotRepository purchaseSnapshotRepository;
    @Autowired
    private PurchaseSnapshotByProductRepository purchaseSnapshotByProductRepository;
    @Autowired
    private PurchaseSnapshotByLineRepository purchaseSnapshotByLineRepository;
    @Autowired
    private StatisticInvokeLogService statisticInvokeLogService;
    @Autowired
    private PurchaseCountService purchaseCountService;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private PurchaseCountMapper purchaseCountMapper;
    @Autowired
    private DecreaseLogCrudService decreaseLogCrudService;
    @Autowired
    private MailService mailService;

    @Async
    @CacheLock(prefix="cac-schedule-task-01", expired=30L, autoDelete=false)
    @Scheduled(cron="0 0 0 * * ?")
    public void configureTasks1() {
        logger.info("\u6267\u884c[\u79df\u6237\u8ba2\u9605\u8fc7\u671f\u901a\u77e5]\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\uff0c\u65f6\u95f4: {}", (Object)LocalDateTime.now());
        LocalDate now = LocalDate.now();
        LocalDate startTime = now.minusDays(7L);
        String startTimeStr = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(startTime.atStartOfDay());
        String endTimeStr = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(now.atTime(LocalTime.MAX));
        List purchaseExpiredVOList = this.purchaseMapper.findTenantPurchaseExpiredDetail(startTimeStr, endTimeStr);
        if (purchaseExpiredVOList.isEmpty()) {
            logger.info("[\u79df\u6237\u8ba2\u9605\u8fc7\u671f\u901a\u77e5] \u8ba2\u9605\u5373\u5c06\u8fc7\u671f\u7684\u6570\u91cf\u4e3a0\uff0c\u9000\u51fa...");
            return;
        }
        logger.info("[\u79df\u6237\u8ba2\u9605\u8fc7\u671f\u901a\u77e5] \u8ba2\u9605\u5373\u5c06\u8fc7\u671f {}", (Object)purchaseExpiredVOList);
        List tenantIds = purchaseExpiredVOList.stream().map(TenantPurchaseExpiredVO::getTenantId).collect(Collectors.toList());
        try {
            Map tenants = this.iamService.getTenantSid(tenantIds);
            purchaseExpiredVOList.forEach(o -> o.setTenantSid((Long)tenants.get(o.getTenantId())));
            List platformGoodsCode = this.gmcService.getGoodsCodeByPlatformCode("Athena");
            logger.info("\u8fc7\u671f\u901a\u77e5\u7684\u5546\u54c1\u5e94\u7528\u4fe1\u606f\uff1a{}", (Object)JsonUtils.writeValue((Object)purchaseExpiredVOList));
            for (TenantPurchaseExpiredVO purchaseVO : purchaseExpiredVOList) {
                if (purchaseVO.getExpiredDateTime().isAfter(now.atStartOfDay()) && !platformGoodsCode.contains(purchaseVO.getAppId())) continue;
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("appId", purchaseVO.getAppId());
                params.put("expiredTime", purchaseVO.getExpiredDateTime());
                params.put("tenantSid", purchaseVO.getTenantSid());
                params.put("tenantId", purchaseVO.getTenantId());
                params.put("bufferPeriod", Optional.ofNullable(purchaseVO.getBufferPeriod()).orElse(Boolean.FALSE));
                params.put("expireNotice", purchaseVO.getExpireNotice());
                HashMap<String, HashMap<String, Object>> data = new HashMap<String, HashMap<String, Object>>(1);
                data.put("params", params);
                MessageBody messageData = MessageBody.of((String)SysNoticeEnum.APP_EXPIRED.name(), data);
                messageData.setSysId(purchaseVO.getAppId());
                this.producerService.sys(messageData);
            }
        }
        catch (Exception e) {
            logger.error("\u6267\u884c[\u79df\u6237\u8ba2\u9605\u8fc7\u671f\u901a\u77e5]\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
        logger.info("\u6267\u884c[\u79df\u6237\u8ba2\u9605\u8fc7\u671f\u901a\u77e5]\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f\uff0c\u65f6\u95f4: {}", (Object)LocalDateTime.now());
    }

    @Async
    @CacheLock(prefix="cac-schedule-task-02", expired=30L, autoDelete=false)
    @Scheduled(cron="0 0 0 * * ?")
    public void processMonthlyPlan() {
        LocalDateTime now = LocalDateTime.now();
        logger.info("\u6267\u884c[\u5305\u6708\u5957\u9910]\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\uff0c\u65f6\u95f4: {}", (Object)now);
        List purchaseExpiredVOList = this.purchaseMapper.findMonthlyPlan(now);
        purchaseExpiredVOList.removeIf(a -> LocalDateTimeUtil.isSameDay((LocalDateTime)now, (LocalDateTime)a.getEffectiveDateTime()));
        Map tenantSidMap = this.iamService.getTenantSid(purchaseExpiredVOList.stream().map(CloudPurchaseDTO::getCustomerId).collect(Collectors.toList()));
        for (CloudPurchaseDTO dto : purchaseExpiredVOList) {
            PurchaseCount count = this.purchaseCountCrudService.findByPurchaseId(dto.getPurchaseId());
            if (count == null) continue;
            logger.info("[\u5305\u6708\u5957\u9910]purchaseId:{},\u539ftotal:{},\u539fremain:{},\u6bcf\u6708\u6388\u6743\u6570\u91cf:{}", new Object[]{dto.getPurchaseId(), count.getTotalUsageBound(), count.getRemainUsageBound(), count.getMonthlyUsageBound()});
            this.saveLog(count);
            int newCount = count.getMonthlyUsageBound();
            String remark = "\u5305\u6708\u56fa\u5b9a\u6578\u91cf\u6392\u7a0b\u7522\u751f\uff0c\u672a\u8017\u7528\u6578\u91cf\u4e0d\u6d41\u8f49\u81f3\u6b21\u6708";
            if (dto.isTransferUnused()) {
                newCount = count.getRemainUsageBound() + count.getMonthlyUsageBound();
                remark = "\u5305\u6708\u56fa\u5b9a\u6578\u91cf\u6392\u7a0b\u7522\u751f\uff0c\u672a\u8017\u7528\u6578\u91cf\u6d41\u8f49\u81f3\u6b21\u6708";
            }
            count.setTotalUsageBound(newCount);
            count.setRemainUsageBound(newCount);
            logger.info("[\u5305\u6708\u5957\u9910]purchaseId:{},\u6388\u6743\u6570\u91cf\u66f4\u65b0\u4e3a:{}", (Object)dto.getPurchaseId(), (Object)newCount);
            this.purchaseCountCrudService.update((BaseEntity)count);
            this.saveRecord(dto, count, remark);
            this.sysNotify(dto, count, (Long)tenantSidMap.get(dto.getCustomerId()));
        }
        logger.info("\u6267\u884c[\u5305\u6708\u5957\u9910]\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f\uff0c\u65f6\u95f4: {}", (Object)now);
    }

    private void saveLog(PurchaseCount count) {
        PurchaseCountLog purchaseCountLog = new PurchaseCountLog();
        BeanUtils.copyProperties((Object)count, (Object)purchaseCountLog);
        purchaseCountLog.setModifyDate(LocalDateTime.now());
        purchaseCountLog.setCategory(0);
        this.purchaseCountLogRepository.save((Object)purchaseCountLog);
    }

    private void sysNotify(CloudPurchaseDTO purchase, PurchaseCount count, Long tenantSid) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("tenantSid", tenantSid);
        data.put("tenantId", purchase.getCustomerId());
        data.put("tenantName", purchase.getCustomerName());
        data.put("monthlyUsage", count.getMonthlyUsageBound());
        data.put("totalUsage", count.getTotalUsageBound());
        MessageBody messageBody = MessageBody.of((String)"APP_MONTHLY", data);
        messageBody.setTenantSid(tenantSid);
        messageBody.setTenantId(purchase.getCustomerId());
        messageBody.setSysId(purchase.getProductCode());
        this.producerService.sys(messageBody);
    }

    private void saveRecord(CloudPurchaseDTO dto, PurchaseCount count, String remark) {
        Purchase purchase = this.purchaseCrudService.findByPurchaseId(dto.getPurchaseId());
        Record record = new Record();
        record.setSid(SnowFlake.getInstance().newId());
        record.setOperate(Operate.Update.name());
        record.setSourceId("Schedule");
        record.setTenantSid(0L);
        Customer customer = this.customerCrudService.findById(purchase.getCustomerId());
        record.setTenantId(purchase.getCustomerId());
        record.setTenantName((String)Optional.ofNullable(customer).map(Customer::getName).orElse(null));
        Map goods = this.gmcService.getGoodsByGoodsIds(Collections.singletonList(purchase.getProductCode()));
        GoodsVO goodsVO = Optional.ofNullable(goods.get(purchase.getProductCode())).orElse(new GoodsVO());
        record.setGoodsCategory(goodsVO.getCatoryId());
        record.setOrderCode("AutoGenerate");
        record.setGoodsCode(goodsVO.getCode());
        record.setGoodsName(goodsVO.getDisplayName());
        record.setPaymentType(goodsVO.getPaymentType().intValue());
        record.setCustomunit(goodsVO.getCustomUnit());
        record.setUserCount(count.getMonthlyUsageBound());
        record.setUseCount(count.getMonthlyUsageBound());
        record.setEffectiveDate(purchase.getEffectiveDateTime());
        record.setExpiredDate(purchase.getExpiredDateTime());
        record.setRemark(remark);
        this.recordCrudService.create((BaseEntity)record);
    }

    @Async
    @CacheLock(prefix="cac_schedule_task_03", expired=30L, autoDelete=false)
    @Scheduled(cron="0 0 0 * * ?")
    public void cleanOverUse() {
        LocalDateTime now = LocalDateTime.now();
        logger.info("\u6267\u884c[\u8d85\u989d\u68c0\u67e5]\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\uff0c\u65f6\u95f4: {}", (Object)now);
        List vo = this.purchaseMapper.findOverUsed(now);
        vo.removeIf(a -> "athena".equalsIgnoreCase(a.getProductCode()));
        if (CollectionUtils.isEmpty((Collection)vo)) {
            return;
        }
        for (OverUseVO overUseVO : vo) {
            String key = String.format("cac:overUse:%s::%s", overUseVO.getTenantId(), overUseVO.getProductCode());
            OverUseRedisVO redisRecord = (OverUseRedisVO)RedisUtils.get((Object)key, OverUseRedisVO.class);
            if (redisRecord == null) {
                redisRecord = new OverUseRedisVO(LocalDate.now(), LocalDate.now().plusDays(7L));
                RedisUtils.set((String)key, (Object)redisRecord, (Duration)Duration.ofMinutes(11550L));
            }
            overUseVO.setCleanDate(DateTimeFormatter.ofPattern("yyyy/MM/dd").format(redisRecord.getRemoveDay()));
            if (redisRecord.getRemoveDay().isBefore(LocalDate.now())) {
                this.doCleanUsers(overUseVO);
                RedisUtils.delete((String)key);
                continue;
            }
            this.sendOverUseEmail(overUseVO);
        }
        logger.info("\u6267\u884c[\u8d85\u989d\u68c0\u67e5]\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f\uff0c\u65f6\u95f4: {}", (Object)now);
    }

    private void sendOverUseEmail(OverUseVO overUseVO) {
        MessageBody cacMessage = new MessageBody();
        cacMessage.setOpType("OMC_AUTH_USER_COUNT");
        cacMessage.setData((Object)overUseVO);
        this.producerService.msg(cacMessage);
    }

    private void doCleanUsers(OverUseVO overUseVO) {
        try {
            String purchaseId = overUseVO.getPurchaseId();
            List userInCountings = this.userInCountingCrudService.findByPurchaseId(purchaseId);
            userInCountings.removeIf(a -> UserIdUtil.isDigiwin((String)a.getUserId()));
            int actualUserSize = userInCountings.size();
            int authTotal = overUseVO.getTotal();
            userInCountings.sort(Comparator.comparing(BaseEntity::getCreateDate, Comparator.nullsLast(LocalDateTime::compareTo)));
            ArrayList survivors = new ArrayList();
            if (userInCountings.size() >= overUseVO.getTotal()) {
                for (int i = 0; i < overUseVO.getTotal(); ++i) {
                    survivors.add(userInCountings.get(i));
                }
            }
            userInCountings.removeAll(survivors);
            if (!userInCountings.isEmpty()) {
                this.transactionUtil.runWithTransaction(() -> this.deleteUserInCountings(userInCountings, purchaseId));
                Purchase purchase = this.purchaseCrudService.findByPurchaseId(purchaseId);
                String remark = "\u7cfb\u7edfcac\u8d85\u989d\u68c0\u67e5\u964dU\u5904\u7406\uff1a\u6388\u6743\u6570\u91cf=" + authTotal + "\uff0c\u5b9e\u9645\u4f7f\u7528\u6570\u91cf=" + actualUserSize + "\uff0c\u672c\u6b21\u79fb\u9664\u6570\u91cf=" + userInCountings.size();
                this.lmcService.saveCleanUser(purchase, userInCountings, overUseVO.getTenantId(), remark);
            }
        }
        catch (Exception e) {
            logger.error("doCleanUsers failed", (Throwable)e);
        }
    }

    public void deleteUserInCountings(List<UserInCounting> userInCountings, String purchaseId) {
        for (UserInCounting userInCounting : userInCountings) {
            this.userInCountingCrudService.deleteById(userInCounting.getSid());
        }
        PurchaseCount count = this.purchaseCountCrudService.findByPurchaseId(purchaseId);
        count.setUserCountBound(count.getUserCountBound() - userInCountings.size());
        this.purchaseCountCrudService.update((BaseEntity)count);
    }

    @Async
    @CacheLock(prefix="cac-schedule-task-04", expired=30L, autoDelete=false)
    @Scheduled(cron="0 0 0 * * ?")
    @Transactional
    public void savePurchaseSnapshot() {
        logger.info("\u5f00\u59cb\u6388\u6743\u7528\u6237\u7edf\u8ba1");
        String nowMonth = DateUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy-MM");
        List all = this.purchaseMapper.findSnapshot(null);
        List allTenantIds = all.stream().map(PurchaseSnapshot::getTenantId).distinct().collect(Collectors.toList());
        Map tenantMap = this.iamService.getAllTenantUserCountExcludeTest(allTenantIds).stream().collect(Collectors.toMap(TenantInfo::getId, Function.identity()));
        List detail = all.stream().filter(a -> tenantMap.containsKey(a.getTenantId())).collect(Collectors.toList());
        this.saveDetail(detail, nowMonth, tenantMap);
        Map userIdByPurchase = this.getAuthedUserId(detail);
        this.saveByProduct(detail, nowMonth, userIdByPurchase);
        this.saveByLine(detail, nowMonth, userIdByPurchase);
        logger.info("\u7ed3\u675f\u6388\u6743\u7528\u6237\u7edf\u8ba1");
    }

    private Map<String, List<UserInCountingVO>> getAuthedUserId(List<PurchaseSnapshot> detail) {
        List userInCountingVOS = this.purchaseMapper.findUserIdByPurchaseId(detail.stream().map(PurchaseSnapshot::getPurchaseId).collect(Collectors.toList()));
        userInCountingVOS.removeIf(a -> UserIdUtil.isDigiwin((String)a.getUserId()));
        return userInCountingVOS.stream().collect(Collectors.groupingBy(UserInCountingVO::getPurchaseId));
    }

    private void saveDetail(List<PurchaseSnapshot> detail, String nowMonth, Map<String, TenantInfo> tenantMap) {
        Map goodsMap = this.gmcService.getGoodsByGoodsIds(detail.stream().map(PurchaseSnapshot::getGoodsCode).distinct().collect(Collectors.toList()));
        detail.forEach(a -> {
            a.setMonth(nowMonth);
            GoodsVO goodsVO = Optional.ofNullable(goodsMap.get(a.getGoodsCode())).orElse(new GoodsVO());
            a.setProductCode(goodsVO.getProductCode());
            a.setProductName(goodsVO.getProductName());
            TenantInfo tenantInfo = Optional.ofNullable(tenantMap.get(a.getTenantId())).orElse(new TenantInfo());
            a.setTenantInfo(tenantInfo);
        });
        this.purchaseSnapshotRepository.deleteByMonth(nowMonth);
        this.purchaseSnapshotRepository.saveAll(detail);
    }

    private void saveByProduct(List<PurchaseSnapshot> detail, String nowMonth, Map<String, List<UserInCountingVO>> userIdByPurchase) {
        Map<String, List<PurchaseSnapshot>> detailByGoodsCode = detail.stream().collect(Collectors.groupingBy(PurchaseSnapshot::getGoodsCode));
        ArrayList<PurchaseSnapshotByProduct> purchaseSnapshotByProducts = new ArrayList<PurchaseSnapshotByProduct>();
        for (Map.Entry<String, List<PurchaseSnapshot>> entry : detailByGoodsCode.entrySet()) {
            List<PurchaseSnapshot> allTenantByCurrentGoods = entry.getValue();
            PurchaseSnapshotByProduct byProductEntity = new PurchaseSnapshotByProduct();
            purchaseSnapshotByProducts.add(byProductEntity);
            byProductEntity.setMonth(nowMonth);
            PurchaseSnapshot aDetail = allTenantByCurrentGoods.get(0);
            byProductEntity.setGoodsCode(aDetail.getGoodsCode());
            byProductEntity.setGoodsName(aDetail.getGoodsName());
            byProductEntity.setProductCode(aDetail.getProductCode());
            byProductEntity.setProductName(aDetail.getProductName());
            byProductEntity.setTenantCount(Integer.valueOf(allTenantByCurrentGoods.size()));
            byProductEntity.setRegisterCount(Integer.valueOf(allTenantByCurrentGoods.stream().map(PurchaseSnapshot::getTenantInfo).mapToInt(TenantInfo::getCount).sum()));
            byProductEntity.setTotal(Integer.valueOf(allTenantByCurrentGoods.stream().mapToInt(PurchaseSnapshot::getTotal).sum()));
            byProductEntity.setAuthTotal(Integer.valueOf(allTenantByCurrentGoods.stream().mapToInt(a -> ((List)Optional.ofNullable(userIdByPurchase.get(a.getPurchaseId())).orElse(new ArrayList())).size()).sum()));
        }
        this.purchaseSnapshotByProductRepository.deleteByMonth(nowMonth);
        this.purchaseSnapshotByProductRepository.saveAll(purchaseSnapshotByProducts);
    }

    private void saveByLine(List<PurchaseSnapshot> detail, String nowMonth, Map<String, List<UserInCountingVO>> userIdByPurchase) {
        Map<String, List<PurchaseSnapshot>> detailByline = detail.stream().filter(a -> a.getProductCode() != null).collect(Collectors.groupingBy(PurchaseSnapshot::getProductCode));
        ArrayList<PurchaseSnapshotByLine> purchaseSnapshotByLines = new ArrayList<PurchaseSnapshotByLine>();
        for (Map.Entry<String, List<PurchaseSnapshot>> entry : detailByline.entrySet()) {
            List<PurchaseSnapshot> allTenantByCurrentLine = entry.getValue();
            PurchaseSnapshotByLine byLneEntity = new PurchaseSnapshotByLine();
            purchaseSnapshotByLines.add(byLneEntity);
            byLneEntity.setMonth(nowMonth);
            PurchaseSnapshot aDetail = allTenantByCurrentLine.get(0);
            byLneEntity.setProductCode(aDetail.getProductCode());
            byLneEntity.setProductName(aDetail.getProductName());
            byLneEntity.setTenantCount(Integer.valueOf((int)allTenantByCurrentLine.stream().map(PurchaseSnapshot::getTenantId).distinct().count()));
            byLneEntity.setRegisterCount(Integer.valueOf(allTenantByCurrentLine.stream().map(PurchaseSnapshot::getTenantInfo).distinct().mapToInt(TenantInfo::getCount).sum()));
            byLneEntity.setTotal(Integer.valueOf(allTenantByCurrentLine.stream().mapToInt(PurchaseSnapshot::getTotal).sum()));
            byLneEntity.setAuthTotal(Long.valueOf(allTenantByCurrentLine.stream().map(a -> Optional.ofNullable(userIdByPurchase.get(a.getPurchaseId())).orElse(new ArrayList())).flatMap(Collection::stream).map(UserInCountingVO::getUserId).distinct().count()));
        }
        this.purchaseSnapshotByLineRepository.deleteByMonth(nowMonth);
        this.purchaseSnapshotByLineRepository.saveAll(purchaseSnapshotByLines);
    }

    @Async
    @CacheLock(prefix="cac-schedule-task-05", expired=30L, autoDelete=false)
    @Scheduled(cron="0 0 0 * * ?")
    public void statisticDayAndMonthInvokeRecord() {
        logger.info("\u5f00\u59cbAPI\u8c03\u7528\u8bb0\u5f55\u7edf\u8ba1,\u65f6\u95f4:{}", (Object)LocalDateTime.now());
        LocalDate today = LocalDate.now();
        LocalDate yesterday = today.minusDays(1L);
        this.statisticInvokeLogService.statisticDayAndMonthInvokeRecord(yesterday, today);
        logger.info("\u7ed3\u675fAPI\u8c03\u7528\u8bb0\u5f55\u7edf\u8ba1,\u65f6\u95f4:{}", (Object)LocalDateTime.now());
    }

    @Async
    @CacheLock(prefix="cac-schedule-task-06", expired=30L, autoDelete=false)
    @Scheduled(cron="0 0 7 * * ?")
    public void usageAlert() {
        logger.info("\u6267\u884c[\u7528\u91cf\u9884\u8b66]\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\uff0c\u65f6\u95f4: {}", (Object)LocalDateTime.now());
        List usageAlertDetailList = this.purchaseCountService.getNeedAlertsData(GoodsCategoryEnum.getNeedUsageAlertCategoryIds());
        if (CollectionUtils.isEmpty((Collection)usageAlertDetailList)) {
            logger.info("\u6267\u884c[\u7528\u91cf\u9884\u8b66]\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f\uff0c\u65f6\u95f4: {}", (Object)LocalDateTime.now());
            return;
        }
        List paymentTypes = this.gmcService.getPaymentType();
        Map<String, String> paymentTypeMap = paymentTypes.stream().collect(Collectors.toMap(PaymentTypeVO::uniqueKey, PaymentTypeVO::getName));
        List<String> custUnitList = Arrays.asList("\u81ea\u5b9a\u5355\u4f4d", "\u81ea\u8a02\u55ae\u4f4d", "\u55ae\u4f4d/\u6708", "\u5355\u4f4d/\u6708");
        usageAlertDetailList.forEach(e -> {
            String paymentTypeName = (String)paymentTypeMap.get(e.getCategoryId() + "-" + e.getPaymentType());
            String tempUnit = e.getUnit();
            if (custUnitList.contains(paymentTypeName)) {
                String[] paymentTypeArr = paymentTypeName.split("/");
                if (paymentTypeArr.length == 2) {
                    e.setUnit(tempUnit + "/" + paymentTypeArr[1]);
                } else {
                    e.setUnit(tempUnit);
                }
            } else {
                e.setUnit(paymentTypeName);
            }
            if (GoodsCategoryEnum.API.name().equalsIgnoreCase(e.getCategoryId())) {
                e.setCategoryName("API");
            } else {
                e.setCategoryName(DeployAreaEnum.isAzure((String)this.envProperties.getDeployArea()) ? "\u8a08\u91cf\u5546\u54c1" : "\u8ba1\u91cf\u5546\u54c1");
            }
            if (Objects.equals(3, e.getPaymentType())) {
                e.setTotalUsageDesc("\u4e0d\u9650\u5236");
            } else {
                e.setTotalUsageDesc(Optional.ofNullable(e.getTotalUsage()).map(String::valueOf).orElse("0"));
            }
        });
        List<UsageAlertVO> usageAlertList = usageAlertDetailList.stream().collect(Collectors.groupingBy(UsageAlertDetailVO::getTenantId)).entrySet().stream().map(e -> {
            UsageAlertVO usageAlertVO = new UsageAlertVO();
            usageAlertVO.setTenantId((String)e.getKey());
            usageAlertVO.setTenantName(((UsageAlertDetailVO)((List)e.getValue()).get(0)).getTenantName());
            usageAlertVO.setUsageAlertDetailList((List)e.getValue());
            return usageAlertVO;
        }).collect(Collectors.toList());
        usageAlertList.forEach(e -> {
            MessageBody cacMessage = new MessageBody();
            cacMessage.setOpType("OMC_API_RESOURCE_USAGE_ALERT");
            cacMessage.setData(e);
            this.producerService.msg(cacMessage);
        });
        List purchaseCountSidList = usageAlertDetailList.stream().map(UsageAlertDetailVO::getSid).collect(Collectors.toList());
        this.purchaseCountMapper.increaseAlertCount(purchaseCountSidList);
        logger.info("\u6267\u884c[\u7528\u91cf\u9884\u8b66]\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f\uff0c\u65f6\u95f4: {}", (Object)LocalDateTime.now());
    }

    @CacheLock(prefix="cac-schedule-task-07", expired=30L, autoDelete=false)
    @Scheduled(cron="0 0 4 * * ? ")
    public void syncDmcResourceGoodsUseRecord() {
        LocalDate previousDay = LocalDate.now().minusDays(1L);
        LocalDateTime startOfDay = previousDay.atStartOfDay();
        LocalDateTime endOfDay = previousDay.atTime(23, 59, 59);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        this.decreaseLogCrudService.syncDmcResourceGoodsUseRecord(startOfDay.format(formatter), endOfDay.format(formatter));
    }

    @CacheLock(prefix="cac-schedule-task-08", expired=30L, autoDelete=false)
    @Scheduled(cron="0 0 23 * * ?")
    public void sendResourceGoodsExpire() {
        logger.info("\u5f00\u59cb\u626b\u63cf\u5373\u5c06\u8fc7\u671f\u7684\u8ba1\u91cf\u5546\u54c1\u4fe1\u606f\u5e76\u4e14\u53d1\u9001\u90ae\u4ef6\u901a\u77e5");
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime nowAfterThirty = LocalDateTime.now().plusDays(31L);
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String beginTime = dtf.format(now);
        String endTime = dtf.format(nowAfterThirty);
        List expiredAuthApps = this.purchaseCountMapper.getExpiredAuthApps(beginTime, endTime);
        logger.info("\u5373\u5c06\u5230\u671f\u8ba1\u91cf\u5546\u54c1\uff1a{}", (Object)JsonUtils.objToJson((Object)expiredAuthApps));
        List expiredGoodsCodes = expiredAuthApps.stream().map(PurchaseCountLogVO::getProductCode).collect(Collectors.toList());
        List goodsVOS = this.gmcService.getGoodsByGoodsCodes(expiredGoodsCodes);
        ArrayList filterExpiredGoodsVOs = new ArrayList();
        expiredAuthApps.stream().collect(Collectors.groupingBy(PurchaseCountLogVO::getTenantId)).forEach((key, value) -> {
            GoodsExpireVO goodsExpireVO = new GoodsExpireVO();
            goodsExpireVO.setTenantId(key);
            ArrayList tenantFilterExpiredGoodsVOs = new ArrayList();
            value.stream().collect(Collectors.groupingBy(PurchaseCountLogVO::getProductCode, Collectors.groupingBy(PurchaseCountLogVO::getExpiredDateTime))).forEach((skey, svalue) -> {
                GoodsVO matchGoods = goodsVOS.stream().filter(g -> ObjectUtils.nullSafeEquals((Object)g.getCode(), (Object)skey)).findFirst().orElse(null);
                PurchaseCountLogVO purchaseCountLogVO = (PurchaseCountLogVO)svalue.values().stream().findFirst().orElse(Collections.emptyList()).get(0);
                AtomicInteger useCount = new AtomicInteger(purchaseCountLogVO.getTotalUsageBound() - purchaseCountLogVO.getRemainUsageBound());
                goodsExpireVO.setTenantName(purchaseCountLogVO.getTenantName());
                svalue.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
                    long expiredDays = ChronoUnit.DAYS.between(LocalDate.now(), (Temporal)entry.getKey());
                    if (null != matchGoods && null != matchGoods.getNotificationCycle() && ScheduleTaskServiceImpl.get((Long)expiredDays, (int)matchGoods.getNotificationCycle())) {
                        logger.info("\u5373\u5c06\u5230\u671f\u8ba1\u91cf\u5546\u54c1\u53d1\u9001\u90ae\u4ef6\uff1a{}", (Object)JsonUtils.objToJson(entry.getValue()));
                        PurchaseCountLogVO finalExpiredInfo = new PurchaseCountLogVO();
                        finalExpiredInfo.setProductCode(((PurchaseCountLogVO)((List)entry.getValue()).get(0)).getProductCode());
                        finalExpiredInfo.setProductName(((PurchaseCountLogVO)((List)entry.getValue()).get(0)).getProductName());
                        finalExpiredInfo.setExpiredDateTime((LocalDateTime)entry.getKey());
                        finalExpiredInfo.setCustomUnit(((PurchaseCountLogVO)((List)entry.getValue()).get(0)).getCustomUnit());
                        for (PurchaseCountLogVO g : (List)entry.getValue()) {
                            finalExpiredInfo.setCurrentTotalUsage(finalExpiredInfo.getCurrentTotalUsage() + g.getCurrentTotalUsage());
                        }
                        if (finalExpiredInfo.getCurrentTotalUsage() > useCount.get()) {
                            finalExpiredInfo.setRemainUsageBound(finalExpiredInfo.getCurrentTotalUsage() - useCount.get());
                            tenantFilterExpiredGoodsVOs.add(finalExpiredInfo);
                        } else {
                            useCount.addAndGet(-finalExpiredInfo.getCurrentTotalUsage());
                        }
                    }
                });
            });
            if (!CollectionUtils.isEmpty(tenantFilterExpiredGoodsVOs)) {
                goodsExpireVO.setExpiredApps(tenantFilterExpiredGoodsVOs);
                filterExpiredGoodsVOs.add(goodsExpireVO);
            }
        });
        logger.info("\u5373\u5c06\u5230\u671f\u8ba1\u91cf\u5546\u54c1\u901a\u77e5\uff1a{}", (Object)JsonUtils.objToJson(filterExpiredGoodsVOs));
        this.mailService.sendExpiredNotice(filterExpiredGoodsVOs);
        logger.info("\u7ed3\u675f\u626b\u63cf\u5373\u5c06\u8fc7\u671f\u7684\u8ba1\u91cf\u5546\u54c1\u4fe1\u606f\u5e76\u4e14\u53d1\u9001\u90ae\u4ef6\u901a\u77e5");
    }

    @CacheLock(prefix="cac-schedule-task-08", expired=30L, autoDelete=false)
    @Scheduled(cron="0 0 0 * * ?")
    public void updateResourceGoodsExpire() {
        logger.info("\u5f00\u59cb\u626b\u63cf\u8fc7\u671f\u7684\u8ba1\u91cf\u5546\u54c1\u4fe1\u606f\u5e76\u4e14\u6263\u51cf");
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String beginTime = dtf.format(LocalDateTime.now().minusDays(1L));
        String endTime = dtf.format(LocalDateTime.now());
        List expiredAuthApps = this.purchaseCountMapper.getExpiredAuthApps(beginTime, endTime);
        logger.info("\u6263\u51cf\u5546\u54c1\u4fe1\u606f\uff1a{}", (Object)JsonUtils.objToJson((Object)expiredAuthApps));
        expiredAuthApps.stream().collect(Collectors.groupingBy(PurchaseCountLogVO::getPurchaseId)).forEach((key, value) -> {
            PurchaseCountLogVO purchaseCountLogVO = (PurchaseCountLogVO)value.get(0);
            AtomicInteger expiredCount = new AtomicInteger();
            value.forEach(p -> expiredCount.addAndGet(p.getCurrentTotalUsage()));
            int useCount = purchaseCountLogVO.getTotalUsageBound() - purchaseCountLogVO.getRemainUsageBound();
            if (expiredCount.get() > useCount) {
                int decreaseCount = expiredCount.get() - useCount;
                this.purchaseCountCrudService.updateRemainUsageBound(decreaseCount, purchaseCountLogVO.getPurchaseId());
                DecreaseLog decreaseLog = new DecreaseLog();
                decreaseLog.setLogId("");
                decreaseLog.setProductCode(purchaseCountLogVO.getProductCode());
                decreaseLog.setProductName(purchaseCountLogVO.getProductName());
                decreaseLog.setAppId("DigiwinCloud");
                decreaseLog.setTenantId(purchaseCountLogVO.getTenantId());
                decreaseLog.setTenantName(purchaseCountLogVO.getTenantName());
                decreaseLog.setAppTenantId(purchaseCountLogVO.getTenantId());
                decreaseLog.setUseUsage(Long.valueOf(decreaseCount));
                decreaseLog.setType(DecreaseLogEnum.RESOURCE.getCode());
                decreaseLog.setOperationType(DecreaseLogOperationTypeEnum.DEDUCT.getCode());
                decreaseLog.setRemark(StrUtil.format((CharSequence)"\u5230\u671f\u672a\u4f7f\u7528\u7528\u91cf\u4f5c\u5e9f\u6263\u9664:{}{}", (Object[])new Object[]{decreaseCount, purchaseCountLogVO.getCustomUnit()}));
                decreaseLog.setUserId("Schedule");
                decreaseLog.setUserName("\u6392\u7a0b");
                this.decreaseLogCrudService.create((BaseEntity)decreaseLog);
            }
        });
        logger.info("\u7ed3\u675f\u626b\u63cf\u8fc7\u671f\u7684\u8ba1\u91cf\u5546\u54c1\u4fe1\u606f\u5e76\u4e14\u6263\u51cf");
    }

    private static boolean get(Long expired, int type) {
        boolean bool = false;
        if (1 == type) {
            bool = numbers.contains(expired);
        } else if (2 == type) {
            bool = 3L == expired;
        }
        return bool;
    }
}

