/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.support.upgrade;

import com.digiwin.dap.middleware.cac.domain.remote.GoodsStrategy;
import com.digiwin.dap.middleware.cac.entity.Purchase;
import com.digiwin.dap.middleware.cac.entity.PurchaseCount;
import com.digiwin.dap.middleware.cac.entity.RecordSource;
import com.digiwin.dap.middleware.cac.service.basic.PurchaseCountCrudService;
import com.digiwin.dap.middleware.cac.service.basic.PurchaseCrudService;
import com.digiwin.dap.middleware.cac.service.basic.RecordSourceCrudService;
import com.digiwin.dap.middleware.cac.support.remote.GmcService;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import java.time.LocalDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Order(value=43400)
@Service
public class UpgradeDatabaseV433TV434Service
extends AbstractUpdateDatabaseService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpgradeDatabaseV433TV434Service.class);
    @Autowired
    private RecordSourceCrudService recordSourceCrudService;
    @Autowired
    private GmcService gmcService;
    @Autowired
    private PurchaseCrudService purchaseCrudService;
    @Autowired
    private PurchaseCountCrudService purchaseCountCrudService;

    public String version() {
        return "4.34.0.0";
    }

    public void update() {
        LOGGER.info("434\u6570\u636e\u5347\u7ea7\u5f00\u59cb {}", (Object)LocalDateTime.now());
        this.addSourceSchedule();
        this.initKcf();
        LOGGER.info("434\u6570\u636e\u5347\u7ea7\u5b8c\u6210 {}", (Object)LocalDateTime.now());
    }

    private void initKcf() {
        String goodsCode = "KCF";
        List kcf = this.purchaseCrudService.findByGoodsCode(goodsCode);
        for (Purchase purchase : kcf) {
            try {
                GoodsStrategy sellingStrategy = this.gmcService.getSellingStrategy(goodsCode, purchase.getStrategyId());
                PurchaseCount count = this.purchaseCountCrudService.findByPurchaseId(purchase.getId());
                count.setMonthlyUsageBound((sellingStrategy.getUseCount() > 0 ? sellingStrategy.getUseCount() : sellingStrategy.getUsersNumber()).intValue());
                purchase.setTransferUnused(Boolean.valueOf(true));
                purchase.setMonthlyPlan(Boolean.valueOf(true));
                this.purchaseCrudService.update((BaseEntity)purchase);
                this.purchaseCountCrudService.update((BaseEntity)count);
            }
            catch (Exception e) {
                LOGGER.error("initKcf failed,id:{}", (Object)purchase.getId(), (Object)e);
            }
        }
    }

    private void addSourceSchedule() {
        RecordSource recordSource;
        List all = this.recordSourceCrudService.findAll();
        if (all.stream().noneMatch(a -> "Schedule".equals(a.getId()))) {
            recordSource = new RecordSource();
            recordSource.setId("Schedule");
            recordSource.setName("\u6392\u7a0b");
            this.recordSourceCrudService.create((BaseEntity)recordSource);
        }
        if (all.stream().noneMatch(a -> "ApplicationChanges".equals(a.getId()))) {
            recordSource = new RecordSource();
            recordSource.setId("ApplicationChanges");
            recordSource.setName("\u5e94\u7528\u53d8\u66f4");
            this.recordSourceCrudService.create((BaseEntity)recordSource);
        }
    }
}

