/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.support.validate.impl;

import com.digiwin.dap.middle.kms.constants.KeyConstant;
import com.digiwin.dap.middleware.cac.domain.CopyAppAuthVO;
import com.digiwin.dap.middleware.cac.domain.ObsoleteTenantAuthInfo;
import com.digiwin.dap.middleware.cac.domain.OrderInfoVO;
import com.digiwin.dap.middleware.cac.domain.TenantPurchaseVO;
import com.digiwin.dap.middleware.cac.domain.UserAuthorizationInfoVO;
import com.digiwin.dap.middleware.cac.domain.enumeration.GoodsCategoryEnum;
import com.digiwin.dap.middleware.cac.domain.enumeration.ProductType;
import com.digiwin.dap.middleware.cac.entity.Purchase;
import com.digiwin.dap.middleware.cac.service.basic.PurchaseCrudService;
import com.digiwin.dap.middleware.cac.support.validate.AuthorizeValidationService;
import com.digiwin.dap.middleware.commons.crypto.AES;
import com.digiwin.dap.middleware.exception.BusinessException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class AuthorizeValidationServiceImpl
implements AuthorizeValidationService {
    @Autowired
    private PurchaseCrudService purchaseCrudService;

    public void checkTenantPurchaseVO(TenantPurchaseVO tenantPurchaseVO) {
        Assert.notNull((Object)tenantPurchaseVO, (String)"\u53c3\u6578\u932f\u8aa4: input");
        Assert.hasText((String)tenantPurchaseVO.getTenantId(), (String)"\u53c3\u6578\u932f\u8aa4: input.tenantId");
        Assert.hasText((String)tenantPurchaseVO.getTenantName(), (String)"\u53c3\u6578\u932f\u8aa4: input.tenantName");
        Assert.notNull((Object)tenantPurchaseVO.getAuthorizations(), (String)"\u53c3\u6578\u932f\u8aa4: input.authorizations");
        tenantPurchaseVO.getAuthorizations().forEach(auth -> {
            Assert.hasText((String)auth.getId(), (String)"\u53c3\u6578\u932f\u8aa4: input.authorizations.id");
            Assert.hasText((String)auth.getCode(), (String)"\u53c3\u6578\u932f\u8aa4: input.authorizations.code");
            Assert.hasText((String)auth.getItemId(), (String)"\u53c3\u6578\u932f\u8aa4: input.authorizations.itemId");
            if (auth.getCategoryId() == null || !GoodsCategoryEnum.contains((String)auth.getCategoryId().toLowerCase())) {
                auth.setCategoryId(ProductType.app.name());
            }
            Assert.hasText((String)auth.getDisplayName(), (String)"\u53c3\u6578\u932f\u8aa4: input.authorizations.displayName");
            Assert.hasText((String)auth.getVersion(), (String)"\u53c3\u6578\u932f\u8aa4: input.authorizations.version");
            Assert.notNull((Object)auth.getSellingStrategy(), (String)"\u53c3\u6578\u932f\u8aa4: input.authorizations.sellingStrategy");
            Assert.hasText((String)auth.getSellingStrategy().getId(), (String)"\u53c3\u6578\u932f\u8aa4: input.authorizations.sellingStrategy.id");
            Assert.notNull((Object)auth.getSellingStrategy().getEnabledModules(), (String)"\u53c3\u6578\u932f\u8aa4: input.authorizations.sellingStrategy.enableModule");
            if (auth.getDealer().booleanValue()) {
                Assert.notNull((Object)auth.getEffectiveTime(), (String)"\u53c3\u6578\u932f\u8aa4: input.authorizations.getEffectiveTime");
                Assert.notNull((Object)auth.getExpiredTime(), (String)"\u53c3\u6578\u932f\u8aa4: input.authorizations.getExpiredTime");
            }
            auth.getSellingStrategy().getEnabledModules().forEach(module -> {
                Assert.hasText((String)module.getId(), (String)"\u53c3\u6578\u932f\u8aa4: input.authorizations.sellingStrategy.module.id");
                Assert.hasText((String)module.getName(), (String)"\u53c3\u6578\u932f\u8aa4: input.authorizations.sellingStrategy.module.name");
            });
        });
    }

    public void checkOrderInfoVO1(OrderInfoVO orderInfoVO) {
        Assert.notNull((Object)orderInfoVO, (String)"orderInfoVO\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)orderInfoVO.getTenantId(), (String)"TenantId:\u79df\u6237id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        Assert.hasText((String)orderInfoVO.getCountingId(), (String)"CountingId:\u5546\u54c1code\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        Assert.notNull((Object)orderInfoVO.getUsers(), (String)"Users:\u7528\u6237List\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
    }

    public void checkOrderInfoVO2(OrderInfoVO orderInfoVO) {
        Assert.notNull((Object)orderInfoVO, (String)"orderInfoVO\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)orderInfoVO.getTenantId(), (String)"TenantId:\u79df\u6237id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        Assert.hasText((String)orderInfoVO.getCountingId(), (String)"CountingId:\u5546\u54c1code\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        Assert.hasText((String)orderInfoVO.getUserId(), (String)"UserId:\u7528\u6237id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
    }

    public void checkOrderInfoVO3(OrderInfoVO orderInfoVO) {
        Assert.notNull((Object)orderInfoVO, (String)"orderInfoVO\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)orderInfoVO.getTenantId(), (String)"TenantId:\u79df\u6237id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        Assert.hasText((String)orderInfoVO.getGoodsCode(), (String)"GoodsCode:\u5546\u54c1code\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        Assert.isTrue((Objects.isNull(orderInfoVO.getDecreaseCount()) || orderInfoVO.getDecreaseCount() > 0 ? 1 : 0) != 0, (String)"DecreaseCount:\u6263\u51cf\u6b21\u6570\u4e0d\u5141\u8bb8\u5c0f\u4e8e1");
    }

    public void checkOrderInfoVO4(OrderInfoVO orderInfoVO) {
        Assert.notNull((Object)orderInfoVO, (String)"orderInfoVO\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)orderInfoVO.getAppId(), (String)"AppId:\u5546\u54c1code\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        Assert.notNull((Object)orderInfoVO.getUsers(), (String)"Users:\u7528\u6237List\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        Assert.hasText((String)orderInfoVO.getType(), (String)"Type:\u64cd\u4f5c\u884c\u4e3a\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((orderInfoVO.getUsers().size() <= 100 ? 1 : 0) != 0, (String)"Users:\u7528\u6237\u6e05\u5355size\u4e0d\u80fd\u5927\u4e8e100");
    }

    public void checkAuthorization(UserAuthorizationInfoVO userAuthorizationInfoVO) {
        Assert.notNull((Object)userAuthorizationInfoVO, (String)"userAuthorizationInfoVO\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)userAuthorizationInfoVO.getTenantId(), (String)"TenantId:\u79df\u6237id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        Assert.hasText((String)userAuthorizationInfoVO.getUserId(), (String)"UserId:\u7528\u6237id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
    }

    public void checkCopyAuthorization(CopyAppAuthVO copyAppAuthVO) {
        Assert.notNull((Object)copyAppAuthVO, (String)"copyAppAuthVO\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)copyAppAuthVO.getSourceTenantId(), (String)"TenantId:\u6765\u6e90\u79df\u6237id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        Assert.notEmpty((Collection)copyAppAuthVO.getCustomers(), (String)"Customers:\u590d\u5236\u76ee\u6807\u79df\u6237\u4e0d\u80fd\u4e3a\u7a7a");
        if (0 == copyAppAuthVO.getType()) {
            Assert.notEmpty((Collection)copyAppAuthVO.getAppIds(), (String)"\u6388\u6743\u5e94\u7528\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            Assert.notEmpty((Collection)copyAppAuthVO.getAuthorizations(), (String)"\u6388\u6743\u5e94\u7528\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            copyAppAuthVO.getAuthorizations().forEach(a -> {
                Assert.hasText((String)a.getId(), (String)"Id\uff1a\u6388\u6743\u5e94\u7528id\u4e0d\u80fd\u4e3a\u7a7a");
                Assert.notNull((Object)a.getStrategySid(), (String)"StrategySid\uff1a\u9500\u552e\u65b9\u6848\u4e0d\u80fd\u4e3a\u7a7a");
            });
        }
    }

    public void checkObsoleteAuthorization(List<ObsoleteTenantAuthInfo> obsoleteTenantAuthInfos) {
        obsoleteTenantAuthInfos.forEach(a -> {
            Assert.hasText((String)a.getTenantId(), (String)"TenantId:\u4f5c\u5e9f\u6388\u6743\u7684\u79df\u6237id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            Assert.hasText((String)a.getGoodsCode(), (String)"GoodsCode:\u4f5c\u5e9f\u5e94\u7528\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        });
    }

    public void checkCopySourceAppAuthorization(CopyAppAuthVO copyAppAuthVO) {
        Assert.notNull((Object)copyAppAuthVO, (String)"copyAppAuthVO\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)copyAppAuthVO.getSourceAppId(), (String)"SourceAppId:\u590d\u5236\u6765\u6e90\u5e94\u7528\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        Assert.hasText((String)copyAppAuthVO.getAppId(), (String)"AppId:\u590d\u5236\u76ee\u6807\u5e94\u7528id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notEmpty((Collection)copyAppAuthVO.getTenantIds(), (String)"TenantIds:\u590d\u5236\u6388\u6743\u7684\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notEmpty((Collection)copyAppAuthVO.getAuthorizations(), (String)"Authorizations:\u590d\u5236\u6388\u6743\u7684\u6388\u6743\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public void checkUserAuthPurchaseVO(TenantPurchaseVO tenantPurchaseVO) {
        Assert.notNull((Object)tenantPurchaseVO, (String)"\u53c3\u6578\u932f\u8aa4: input");
        Assert.hasText((String)tenantPurchaseVO.getTenantId(), (String)"\u53c3\u6578\u932f\u8aa4: input.tenantId");
        Assert.hasText((String)tenantPurchaseVO.getTenantName(), (String)"\u53c3\u6578\u932f\u8aa4: input.tenantName");
        Assert.notNull((Object)tenantPurchaseVO.getAuthorizations(), (String)"\u53c3\u6578\u932f\u8aa4: input.authorizations");
        Assert.notEmpty((Collection)tenantPurchaseVO.getAuthorizations(), (String)"\u53c3\u6578\u932f\u8aa4: input.authorizations");
        tenantPurchaseVO.getAuthorizations().forEach(auth -> Assert.hasText((String)auth.getCode(), (String)"\u53c3\u6578\u932f\u8aa4: input.authorizations.code"));
    }

    public void checkSecretKey(OrderInfoVO orderInfoVO, String secretKey) {
        if (secretKey != null) {
            String[] content = AES.decryptCBC((String)secretKey, (String)KeyConstant.OTHER).split("@#\\$%\\^_");
            if (content.length != 4) {
                throw new BusinessException("\u975e\u6cd5\u6388\u6743\u7801\uff1a" + secretKey);
            }
            orderInfoVO.setTenantId(content[0]);
            orderInfoVO.setGoodsCode(content[1]);
            Purchase purchase = this.purchaseCrudService.findByTenantIdAndGoodsCode(orderInfoVO.getTenantId(), orderInfoVO.getGoodsCode());
            if (purchase != null && !GoodsCategoryEnum.API.id().equals(purchase.getProductType())) {
                throw new BusinessException("\u975eAPI\u5546\u54c1\u6388\u6743\u7801\u7981\u6b62\u4f7f\u7528");
            }
        }
    }
}

