/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.cloud.conditional;

import com.digiwin.dap.middle.cloud.conditional.ConditionalOnMissingBeanWithAnnotation;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.Map;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;

public class MissingBeanWithAnnotationCondition
implements Condition {
    public static final String MISSING_BEAN_WITH_ANNOTATION_NAME = ConditionalOnMissingBeanWithAnnotation.class.getName();
    public static final String MISSING_BEAN_WITH_ANNOTATION_ATTR_VALUE = "value";
    public static final String MISSING_BEAN_WITH_ANNOTATION_ATTR_ANNOTATION = "annotation";

    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        try {
            LinkedList<String> skipClassNames = new LinkedList<String>();
            Map methodMetadataAttrs = metadata.getAnnotationAttributes(MISSING_BEAN_WITH_ANNOTATION_NAME);
            if (CollectionUtils.isEmpty((Map)methodMetadataAttrs)) {
                return false;
            }
            Object value = methodMetadataAttrs.get(MISSING_BEAN_WITH_ANNOTATION_ATTR_VALUE);
            Class<?> returnType = (Class<?>)value;
            if (returnType == Void.class) {
                if (metadata instanceof MethodMetadata) {
                    MethodMetadata methodMetadata = (MethodMetadata)metadata;
                    String returnTypeName = methodMetadata.getReturnTypeName();
                    returnType = Class.forName(returnTypeName);
                } else {
                    return false;
                }
            }
            ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
            String[] beanDefinitionNames = beanFactory.getBeanDefinitionNames();
            boolean foundMatchedMethod = false;
            for (String key : beanDefinitionNames) {
                try {
                    Class[] annos;
                    Method[] methods;
                    AnnotatedBeanDefinition annotatedBeanDefinition;
                    AnnotationMetadata meta;
                    String className;
                    foundMatchedMethod = false;
                    BeanDefinition beanDefinition = beanFactory.getBeanDefinition(key);
                    if (!(metadata instanceof MethodMetadata)) continue;
                    MethodMetadata methodMetadata = (MethodMetadata)metadata;
                    String beanClassName = beanDefinition.getBeanClassName();
                    if (beanClassName != null && beanClassName.equals(methodMetadata.getDeclaringClassName()) || !(beanDefinition instanceof AnnotatedBeanDefinition) || skipClassNames.contains(className = (meta = (annotatedBeanDefinition = (AnnotatedBeanDefinition)beanDefinition).getMetadata()).getClassName())) continue;
                    for (Method method : methods = ReflectionUtils.getAllDeclaredMethods(Class.forName(className))) {
                        if (!returnType.getName().equals(method.getReturnType().getName())) continue;
                        foundMatchedMethod = true;
                        break;
                    }
                    skipClassNames.add(className);
                    if (!foundMatchedMethod) continue;
                    for (Class anno : annos = (Class[])methodMetadataAttrs.get(MISSING_BEAN_WITH_ANNOTATION_ATTR_ANNOTATION)) {
                        if (!meta.hasAnnotatedMethods(anno.getName())) continue;
                        return false;
                    }
                }
                catch (Throwable ex) {
                    // empty catch block
                }
            }
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }
}

