package com.digiwin.dap.middle.cloud.conditional;

import org.springframework.context.annotation.Conditional;

import java.lang.annotation.*;

/**
 * 条件注解：判断容器是否存在存在配置注解的bean
 * @author blockWilling
 * @date 2023/5/9 16:39
 * @mail kangjin@digiwin.com
 */
@Target({ ElementType.TYPE, ElementType.METHOD })
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Conditional(MissingBeanWithAnnotationCondition.class)
public @interface ConditionalOnMissingBeanWithAnnotation {
    /**
     * 需要过滤的@Bean方法的返回值类型
     */
    Class<?> value() default Void.class;

    /**
     * 需要过滤的@Bean方法的注解
     */
    Class<? extends Annotation>[] annotation() default {};
}
