package com.digiwin.dap.middle.cloud;

import com.digiwin.dap.middle.cloud.exception.DapCloudExceptionHandler;
import com.digiwin.dap.middle.cloud.loadbalance.RestTemplateConfiguration;
import com.digiwin.dap.middle.cloud.propertysource.YamlPropertySourceFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.PropertySource;

/**
 * 整合spring cloud入口配置
 * 1.导入子配置，这里不使用扫包，避免性能问题
 * 2.启用服务发现
 * 3.启用服务声明
 * 4.引入外部配置文件，因为{@link PropertySource}引入的配置优先级最低，所以依赖项目中可以使用配置文件直接覆盖默认配置
 * 5.自动化配置解析顺序，解决依赖缺失
 *
 * @author blockWilling
 * @date 2023/5/9 14:17
 * @mail kangjin@digiwin.com
 */
// 不再支持HttpClientConfiguration，直接移除
@AutoConfiguration
@Import({RestTemplateConfiguration.class})
@EnableDiscoveryClient
@EnableFeignClients
@PropertySource(value = {"classpath:/application-cloud.yml"}, factory = YamlPropertySourceFactory.class)
public class CloudConfiguration {

    @Bean
    public DapCloudExceptionHandler dapCloudExceptionHandler() {
        return new DapCloudExceptionHandler();
    }
}
