package com.digiwin.dap.middle.cloud.loadbalance;

import com.digiwin.dap.middle.cloud.conditional.ConditionalOnMissingBeanWithAnnotation;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;

/**
 * {@link RestTemplate}支持服务发现
 *
 * @author blockWilling
 * @date 2023/5/9 14:21
 * @mail kangjin@digiwin.com
 */
@Configuration(proxyBeanMethods = false)
public class RestTemplateConfiguration {
    public static final String LOADBALANCED_RESTTEMPLATE="lbRestTemplate";

    @Bean
    @LoadBalanced
    @ConditionalOnMissingBeanWithAnnotation(annotation={LoadBalanced.class})
    @Qualifier(LOADBALANCED_RESTTEMPLATE)
    RestTemplate lbRestTemplate() {
        return new RestTemplate();
    }
}
