package com.digiwin.dap.middleware.commons.crypto;

import org.bouncycastle.crypto.AlphabetMapper;
import org.bouncycastle.crypto.util.BasicAlphabetMapper;

import java.nio.charset.StandardCharsets;

/**
 * @author michael
 * @since 1.0.9
 */
public class FPE {

    private static final AlphabetMapper NUMBER_ALPHABET_MAPPER = new BasicAlphabetMapper("0123456789");

    /**
     * 数字保留格式加密
     *
     * @param key  密钥key
     * @param data 加密文本
     * @return 密文
     * @since 1.0.9
     */
    public static String numberEncrypt(byte[] key, String data) {
        byte[] tweak = String.valueOf(System.currentTimeMillis()).getBytes(StandardCharsets.UTF_8);
        cn.hutool.crypto.symmetric.fpe.FPE fpe = new cn.hutool.crypto.symmetric.fpe.FPE(cn.hutool.crypto.symmetric.fpe.FPE.FPEMode.FF1, key, NUMBER_ALPHABET_MAPPER, tweak);
        return fpe.encrypt(data);
    }
}
