package com.digiwin.dap.middleware.commons.util;

import com.digiwin.dap.middleware.util.JsonUtils;
import freemarker.template.Configuration;
import freemarker.template.Template;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.StringWriter;

/**
 * freemarker工具类
 *
 * @author michael
 * @since 1.0.8
 */
@SuppressWarnings("findsecbugs:TEMPLATE_INJECTION_FREEMARKER")
public class FreemarkerUtils {

    private static final Logger logger = LoggerFactory.getLogger(FreemarkerUtils.class);

    private static final Configuration configuration;

    static {
        configuration = new Configuration(Configuration.VERSION_2_3_20);
        configuration.setClassForTemplateLoading(FreemarkerUtils.class, "/static/templates");
        configuration.setDefaultEncoding("utf-8");
    }

    private FreemarkerUtils() {
    }

    public static String processFile(String fileName, Object param) {
        try {
            Template template = configuration.getTemplate(fileName);
            StringWriter sw = new StringWriter();
            template.process(param, sw);
            return sw.toString();
        } catch (Exception e) {
            logger.error("【freemarker】 模板处理异常, fileName:{},param:{}", fileName, JsonUtils.objToJson(param), e);
            return null;
        }
    }

    public static String processString(String s, Object param) {
        try {
            StringWriter result = new StringWriter();
            Template template = new Template("strTpl", s, new Configuration(Configuration.VERSION_2_3_23));
            template.process(param, result);
            return result.toString();
        } catch (Exception e) {
            logger.error("【freemarker】 模板处理异常, 字符串:{},param:{}", s, JsonUtils.objToJson(param), e);
            return null;
        }
    }
}
