package com.digiwin.dap.middleware.domain;

import com.digiwin.dap.middleware.commons.core.codec.URL;
import com.digiwin.dap.middleware.util.JsonUtils;

import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;

/**
 * 签名信息
 *
 * @author fobgochod
 * @since 1.0.8
 */
public class DapSign {

    private String nonce;
    private String timestamp;
    private String sign;

    public static DapSign get(String json) {
        return get(json, DapSign.class);
    }

    public static <T> T get(String json, Class<T> classType) {
        String parsed = new String(json.getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
        String decode = URL.decode(parsed);
        return JsonUtils.jsonToObj(decode, classType);
    }

    public String getNonce() {
        return nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public String getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public String getSign() {
        return sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", DapSign.class.getSimpleName() + "[", "]")
                .add("nonce='" + nonce + "'")
                .add("timestamp='" + timestamp + "'")
                .add("sign='" + sign + "'")
                .toString();
    }
}
