package com.digiwin.dap.middleware.domain;

/**
 * 标准输出
 *
 * @author fobgochod
 * @since 1.0.11
 */
public class StdData<T> {

    private Integer code;
    private String message;
    private T data;
    private Boolean success;

    public StdData() {
    }

    public StdData(Integer code, String message, T data, Boolean success) {
        this.code = code;
        this.message = message;
        this.data = data;
        this.success = success;
    }

    /**
     * 标准输出
     *
     * @param data 数据
     * @param <T>  类型
     * @return T
     * @see StdData#ok(Object)
     * @since 1.0.8
     */
    @Deprecated
    public static <T> StdData<T> ofSuccess(T data) {
        return ok(data);
    }

    /**
     * 错误输出
     *
     * @param code    错误码
     * @param message 错误描述
     * @param <T>     类型
     * @return T
     * @see StdData#of(int, String)
     * @since 1.0.8
     */
    @Deprecated
    public static <T> StdData<T> ofFail(int code, String message) {
        return of(code, message);
    }

    public static DefaultBuilder ok() {
        return of(true).code(200).message("success");
    }

    public static DefaultBuilder of() {
        return of(false);
    }

    public static DefaultBuilder code(int code) {
        return of(false).code(code);
    }

    public static DefaultBuilder of(boolean success) {
        return new DefaultBuilder(success);
    }

    public static <T> StdData<T> ok(T body) {
        return ok().body(body);
    }

    public static <T> StdData<T> of(int code, String message) {
        return of().code(code).message(message).build();
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public Boolean getSuccess() {
        return success;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public static class DefaultBuilder {

        private final boolean status;
        private Integer code;
        private String message;

        public DefaultBuilder(boolean status) {
            this.status = status;
        }

        public DefaultBuilder code(int code) {
            this.code = code;
            return this;
        }

        public DefaultBuilder message(String message) {
            this.message = message;
            return this;
        }

        public <T> StdData<T> build() {
            return body(null);
        }

        public <T> StdData<T> body(T body) {
            return new StdData<>(code, message, body, status);
        }
    }
}
