/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.commons.core.codec;

import com.digiwin.dap.middleware.exception.CommonException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Base58 {
    private static final Logger logger = LoggerFactory.getLogger(Base58.class);
    private static final String DIGITS = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz";

    private Base58() {
    }

    public static String policyId(String str) {
        String encodeStr;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] bytes = messageDigest.digest(str.getBytes(StandardCharsets.UTF_8));
            bytes = messageDigest.digest(bytes);
            encodeStr = Base58.encode(bytes).substring(0, 20);
        }
        catch (Exception e) {
            throw new CommonException(e);
        }
        return encodeStr;
    }

    public static String encode(byte[] data) {
        return Base58.encodePlain(Base58.addCheckSum(data));
    }

    private static String encodePlain(byte[] data) {
        BigInteger intData = BigInteger.ZERO;
        for (byte aData : data) {
            int d = aData & 0xFF;
            intData = BigInteger.valueOf(256L).multiply(intData).add(new BigInteger(d + ""));
        }
        StringBuilder result = new StringBuilder();
        while (0 != intData.intValue()) {
            BigInteger remainder = intData.mod(BigInteger.valueOf(58L));
            intData = intData.divide(BigInteger.valueOf(58L));
            result.insert(0, DIGITS.split("")[remainder.intValue()]);
        }
        for (int i = 0; i < data.length && data[i] == 0; ++i) {
            result.insert(0, '1');
        }
        return result.toString();
    }

    private static byte[] addCheckSum(byte[] data) {
        byte[] checkSum = Base58.getCheckSum(data);
        return Base58.concatArrays(data, checkSum);
    }

    private static byte[] getCheckSum(byte[] data) {
        byte[] result = new byte[4];
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] hash1 = md.digest(data);
            byte[] hash2 = md.digest(hash1);
            System.arraycopy(hash2, 0, result, 0, result.length);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private static byte[] concatArrays(byte[] arr1, byte[] arr2) {
        byte[] result = new byte[arr1.length + arr2.length];
        System.arraycopy(arr1, 0, result, 0, arr1.length);
        System.arraycopy(arr2, 0, result, arr1.length, arr2.length);
        return result;
    }
}

