/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.commons.crypto;

import cn.hutool.crypto.KeyUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.asymmetric.AsymmetricAlgorithm;
import cn.hutool.crypto.asymmetric.AsymmetricCrypto;
import cn.hutool.crypto.asymmetric.KeyType;
import com.digiwin.dap.middleware.commons.core.codec.Base64;
import com.digiwin.dap.middleware.commons.crypto.constant.AlgorithmEnum;
import com.digiwin.dap.middleware.commons.crypto.constant.TransformationEnum;
import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.exception.CommonException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;

public class RSA {
    private static final cn.hutool.crypto.asymmetric.RSA rsa_ = SecureUtil.rsa();

    private RSA() {
    }

    public static String encrypt(String data, String publicKeyBase64) {
        PublicKey publicKey = KeyUtil.generatePublicKey((String)AsymmetricAlgorithm.RSA_ECB_PKCS1.getValue(), (byte[])Base64.decode(publicKeyBase64));
        byte[] bytes = ((AsymmetricCrypto)rsa_.setPublicKey(publicKey)).encrypt(data, KeyType.PublicKey);
        return Base64.encode(bytes);
    }

    public static String decrypt(String data, String privateKeyBase64) {
        PrivateKey privateKey = KeyUtil.generatePrivateKey((String)AsymmetricAlgorithm.RSA_ECB_PKCS1.getValue(), (byte[])Base64.decode(privateKeyBase64));
        byte[] bytes = ((AsymmetricCrypto)rsa_.setPrivateKey(privateKey)).decrypt(data, KeyType.PrivateKey);
        return StrUtils.str(bytes);
    }

    public static byte[] encryptOAEP(byte[] data, String publicKeyBase64) {
        byte[] bytes = Base64.decode(publicKeyBase64);
        return RSA.encrypt(data, bytes, TransformationEnum.RSA_ECB_OAEP.getValue());
    }

    public static byte[] decryptOAEP(byte[] data, String privateKeyBase64) {
        byte[] bytes = Base64.decode(privateKeyBase64);
        return RSA.decrypt(data, bytes, TransformationEnum.RSA_ECB_OAEP.getValue());
    }

    public static byte[] encrypt(byte[] data, byte[] publicKey, String transformation) {
        try {
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKey);
            KeyFactory keyFactory = KeyFactory.getInstance(AlgorithmEnum.RSA.getValue());
            PublicKey key = keyFactory.generatePublic(keySpec);
            Cipher cipher = Cipher.getInstance(transformation);
            if (Objects.equals(transformation, TransformationEnum.RSA_ECB_OAEP.getValue())) {
                OAEPParameterSpec params = new OAEPParameterSpec("SHA-256", "MGF1", new MGF1ParameterSpec("SHA-1"), PSource.PSpecified.DEFAULT);
                cipher.init(1, (Key)key, params);
            } else {
                cipher.init(1, key);
            }
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new CommonException("RSA\u52a0\u5bc6\u5f02\u5e38", e);
        }
    }

    public static byte[] decrypt(byte[] data, byte[] privateKey, String transformation) {
        try {
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKey);
            KeyFactory keyFactory = KeyFactory.getInstance(AlgorithmEnum.RSA.getValue());
            PrivateKey key = keyFactory.generatePrivate(keySpec);
            Cipher cipher = Cipher.getInstance(transformation);
            if (Objects.equals(transformation, TransformationEnum.RSA_ECB_OAEP.getValue())) {
                OAEPParameterSpec oaepParams = new OAEPParameterSpec("SHA-256", "MGF1", new MGF1ParameterSpec("SHA-1"), PSource.PSpecified.DEFAULT);
                cipher.init(2, (Key)key, oaepParams);
            } else {
                cipher.init(2, key);
            }
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new CommonException("RSA\u89e3\u5bc6\u5f02\u5e38", e);
        }
    }

    public static KeyPair generateKeyPair(int keySize) {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(AlgorithmEnum.RSA.getValue());
            keyPairGenerator.initialize(keySize);
            return keyPairGenerator.generateKeyPair();
        }
        catch (Exception e) {
            throw new CommonException("\u83b7\u53d6RSA\u5bc6\u94a5\u5f02\u5e38,\u5bc6\u94a5\u957f\u5ea6:" + keySize, e);
        }
    }
}

