/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.commons.util;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StrUtils {
    public static final Charset UTF_8 = StandardCharsets.UTF_8;

    private StrUtils() {
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static boolean isNotEmpty(String str) {
        return str != null && !str.isEmpty();
    }

    public static boolean hasText(String str) {
        return StrUtils.isNotEmpty(str) && StrUtils.containsText(str);
    }

    private static boolean containsText(CharSequence str) {
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String str(byte[] bytes) {
        return StrUtils.str(bytes, UTF_8);
    }

    public static String str(byte[] data, Charset charset) {
        if (data == null) {
            return null;
        }
        if (null == charset) {
            return new String(data);
        }
        return new String(data, charset);
    }

    public static byte[] bytes(String str) {
        return StrUtils.bytes(str, UTF_8);
    }

    public static byte[] bytes(String str, Charset charset) {
        if (str == null) {
            return new byte[0];
        }
        return str.getBytes(charset);
    }

    public static boolean isValid(String str, String pattern) {
        if (StrUtils.isEmpty(str) || StrUtils.isEmpty(pattern)) {
            return false;
        }
        Matcher matcher = Pattern.compile(pattern).matcher(str);
        return matcher.matches();
    }

    public static boolean isLetterOrNumber(String str) {
        return StrUtils.isValid(str, "^[A-Za-z0-9]+$");
    }

    public static boolean isLowerLetterOrNumber(String str) {
        return StrUtils.isValid(str, "^[a-z0-9]{1,255}$");
    }

    public static String getRandomCode() {
        StringBuilder randomCode = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            int value = (int)(Math.random() * 58.0 + 65.0);
            while (value >= 91 && value <= 96) {
                value = (int)(Math.random() * 58.0 + 65.0);
            }
            randomCode.append((char)value);
        }
        return randomCode.toString();
    }
}

