/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.domain;

import com.digiwin.dap.middleware.constant.enums.AreaEnum;
import com.digiwin.dap.middleware.constant.enums.CloudEnum;
import java.util.Optional;

public enum DeployAreaEnum {
    DevelopLocal(CloudEnum.Develop, AreaEnum.local, ""),
    DevelopDev(CloudEnum.Develop, AreaEnum.dev, ""),
    DevelopGround(CloudEnum.Develop, AreaEnum.ground, ""),
    AliyunPaaS(CloudEnum.Aliyun, AreaEnum.paas, "-paas.digiwincloud.com.cn"),
    AliyunTest(CloudEnum.Aliyun, AreaEnum.test, "-test.digiwincloud.com.cn"),
    HuaweiPressure(CloudEnum.Huawei, AreaEnum.pressure, "-pressure.digiwincloud.com.cn"),
    AliyunAutotest(CloudEnum.Aliyun, AreaEnum.autotest, "-autotest.digiwincloud.com.cn"),
    AzureTest(CloudEnum.Azure, AreaEnum.test, "-test.digiwincloud.com"),
    HuaweiTest(CloudEnum.Huawei, AreaEnum.test, "-hw-test.digiwincloud.com"),
    AliyunProd(CloudEnum.Aliyun, AreaEnum.prod, ".digiwincloud.com.cn"),
    AzureProd(CloudEnum.Azure, AreaEnum.prod, ".digiwincloud.com"),
    HuaweiProd(CloudEnum.Huawei, AreaEnum.prod, "-hw.digiwincloud.com.cn");

    private final CloudEnum cloud;
    private final AreaEnum area;
    private final String suffix;

    private DeployAreaEnum(CloudEnum cloud, AreaEnum area, String suffix) {
        this.cloud = cloud;
        this.area = area;
        this.suffix = suffix;
    }

    public static boolean isProd(String deployArea) {
        return Optional.ofNullable(DeployAreaEnum.get(deployArea)).map(x -> x.area.equals((Object)AreaEnum.prod)).orElse(false);
    }

    public static boolean isTest(String deployArea) {
        return Optional.ofNullable(DeployAreaEnum.get(deployArea)).map(x -> x.area.equals((Object)AreaEnum.test)).orElse(false);
    }

    public static boolean isAliyun(String deployArea) {
        return AliyunProd.name().equalsIgnoreCase(deployArea) || AliyunTest.name().equalsIgnoreCase(deployArea);
    }

    public static boolean isAzure(String deployArea) {
        return Optional.ofNullable(DeployAreaEnum.get(deployArea)).map(x -> x.cloud.equals((Object)CloudEnum.Azure)).orElse(false);
    }

    public static boolean isHuawei(String deployArea) {
        return Optional.ofNullable(DeployAreaEnum.get(deployArea)).map(x -> x.cloud.equals((Object)CloudEnum.Huawei)).orElse(false);
    }

    public static boolean isDev(String deployArea) {
        return AliyunPaaS.name().equals(deployArea) || DevelopDev.name().equals(deployArea);
    }

    public static DeployAreaEnum get(String cloud, String area) {
        for (DeployAreaEnum anEnum : DeployAreaEnum.values()) {
            if (!anEnum.cloud.name().equalsIgnoreCase(cloud) || !anEnum.area.name().equalsIgnoreCase(area)) continue;
            return anEnum;
        }
        return null;
    }

    public static DeployAreaEnum get(String deployArea) {
        for (DeployAreaEnum anEnum : DeployAreaEnum.values()) {
            if (!anEnum.name().equalsIgnoreCase(deployArea)) continue;
            return anEnum;
        }
        return null;
    }

    public CloudEnum getCloud() {
        return this.cloud;
    }

    public AreaEnum getArea() {
        return this.area;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getCloudName() {
        return this.cloud.name();
    }

    public String getAreaName() {
        return this.area.name();
    }
}

