package com.digiwin.dap.middleware.constant;

import java.util.HashMap;
import java.util.Map;

/**
 * 内部固定URL
 *
 * @author fobgochod
 * @since 1.0.8
 */
public class InternalUrl {
    /**
     * token解析 internal是内部使用
     */
    public static final String TOKEN_ANALYZE = "/api/iam/v2/identity/token/analyze";
    public static final String INTERNAL_TOKEN_ANALYZE = "/api/iam/v2/identity/token/analyze/internal";
    /**
     * API访问控制
     */
    public static final String ACCESS_ANALYZE = "/api/ram/v2/access/analyze";
    public static final String BASE_ANALYZE = "/api/ram/v2/access/base/analyze";
    public static final String API_ANALYZE = "/api/ram/v2/access/api/analyze";
    public static final String AUTH_ANALYZE = "/api/ram/v2/access/auth/analyze";
    public static final String AUTHS_ANALYZE = "/api/ram/v2/access/auths/analyze";
    public static final String POLICY_ANALYZE = "/api/ram/v2/access/policy/analyze";
    /**
     * 服务权限 用户和租户层面检查
     */
    public static final String USER_SERVICE_ANALYZE = "/api/ram/v2/access/srv/user/analyze";
    public static final String TENANT_SERVICE_ANALYZE = "/api/ram/v2/access/srv/tenant/analyze";
    /**
     * 登录 集成账号(integration)登录 企业内部用户登录
     */
    public static final String LOGIN = "/api/iam/v2/identity/login";
    public static final String INTEGRATION_LOGIN = "/api/iam/v2/identity/login/internal";
    public static final String INTERNAL_LOGIN = "/api/iam/v2/identity/internal/login";
    /**
     * 获取租户用户商品授权信息
     */
    public static final String SYS_PLATFORM_IDS = "/api/iam/v2/sys/platform/ids";
    public static final String AUTH_CHECK = "/api/cac/v4/authorizations/tenant/user/goods/check";
    /**
     * 获取密钥信息
     */
    public static final String APP_SECRET_CURRENT = "/api/iam/v2/dev/app/secret/current";
    public static final String TENANT_SECRET_CURRENT = "/api/iam/v1/isv/credential/secret/current";
    /**
     * 获取应用开发商
     */
    public static final String DEV_APP_TENANT = "/api/iam/v2/dev/app/one";

    private InternalUrl() {
    }

    public static Map<String, Boolean> tokenAnalyzes() {
        Map<String, Boolean> paths = new HashMap<>(2);
        paths.put(InternalUrl.TOKEN_ANALYZE, Boolean.TRUE);
        paths.put(InternalUrl.INTERNAL_TOKEN_ANALYZE, Boolean.TRUE);
        return paths;
    }

    public static Map<String, Boolean> authAllows() {
        Map<String, Boolean> allowPath = new HashMap<>(11);
        // ram
        allowPath.put(InternalUrl.ACCESS_ANALYZE, Boolean.TRUE);
        allowPath.put(InternalUrl.BASE_ANALYZE, Boolean.TRUE);
        allowPath.put(InternalUrl.API_ANALYZE, Boolean.TRUE);
        allowPath.put(InternalUrl.AUTH_ANALYZE, Boolean.TRUE);
        allowPath.put(InternalUrl.AUTHS_ANALYZE, Boolean.TRUE);
        allowPath.put(InternalUrl.POLICY_ANALYZE, Boolean.TRUE);
        // cac
        allowPath.put(InternalUrl.SYS_PLATFORM_IDS, Boolean.TRUE);
        allowPath.put(InternalUrl.AUTH_CHECK, Boolean.TRUE);
        // iam
        allowPath.put(InternalUrl.APP_SECRET_CURRENT, Boolean.TRUE);
        allowPath.put(InternalUrl.TENANT_SECRET_CURRENT, Boolean.TRUE);
        allowPath.put(InternalUrl.DEV_APP_TENANT, Boolean.TRUE);

        allowPath.put(InternalUrl.LOGIN, Boolean.TRUE);
        allowPath.put(InternalUrl.INTEGRATION_LOGIN, Boolean.TRUE);
        allowPath.put(InternalUrl.INTERNAL_LOGIN, Boolean.TRUE);
        return allowPath;
    }

    public static Map<String, Boolean> policyAllows() {
        Map<String, Boolean> allowPath = new HashMap<>(13);
        allowPath.putAll(tokenAnalyzes());
        allowPath.putAll(authAllows());
        return allowPath;
    }
}
