/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.commons.util;

import com.digiwin.dap.middleware.commons.core.codec.URL;
import com.digiwin.dap.middleware.commons.crypto.AES;
import com.digiwin.dap.middleware.commons.crypto.SignUtils;
import com.digiwin.dap.middleware.domain.DapEncrypt;
import com.digiwin.dap.middleware.domain.DapSign;
import com.digiwin.dap.middleware.util.JsonUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class EncryptUtils {
    private EncryptUtils() {
    }

    public static String encrypt(String key, Object data) {
        String dataJson = JsonUtils.objToJson(data);
        return AES.encryptIvCBC(dataJson, key);
    }

    public static <T> T decrypt(String key, String eData, Class<T> targetType) {
        String data = AES.decryptIvCBC(eData, key);
        return JsonUtils.jsonToObj(data, targetType);
    }

    public static String sign(String key, Object requestBody) {
        return EncryptUtils.sign(key, Collections.emptyMap(), requestBody);
    }

    public static String sign(String key, Map<String, String> queryParams, Object requestBody) {
        DapSign dapSign = EncryptUtils.signInfo(key, queryParams, requestBody);
        return URL.encode(JsonUtils.objToJson(dapSign));
    }

    public static DapSign signInfo(String key, Object requestBody) {
        return EncryptUtils.signInfo(key, Collections.emptyMap(), requestBody);
    }

    public static DapSign signInfo(String key, Map<String, String> queryParams, Object requestBody) {
        HashMap<String, String> signParams = new HashMap<String, String>();
        Map<Object, Object> bodyParams = requestBody == null ? Collections.emptyMap() : JsonUtils.objToMap(requestBody);
        String signData = SignUtils.sign(signParams, key, queryParams, bodyParams);
        DapSign dapSign = new DapSign();
        dapSign.setTimestamp((String)signParams.get("timestamp"));
        dapSign.setNonce((String)signParams.get("nonce"));
        dapSign.setSign(signData);
        return dapSign;
    }

    public static DapEncrypt encryptSign(String key, Object requestBody) {
        return EncryptUtils.encryptSign(key, Collections.emptyMap(), requestBody);
    }

    public static DapEncrypt encryptSign(String key, Map<String, String> queryParams, Object requestBody) {
        String eData = EncryptUtils.encrypt(key, requestBody);
        DapEncrypt body = new DapEncrypt(eData);
        body.setSignHeader(EncryptUtils.sign(key, queryParams, body));
        return body;
    }
}

