/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.util;

import com.digiwin.dap.middleware.exception.CommonException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Date;

public class SnowFlake {
    private static final long START_STAMP = 1613590487000L;
    private static final long SEQUENCE_BIT = 10L;
    private static final long MACHINE_BIT = 3L;
    private static final long MAX_SEQUENCE = 1023L;
    private static final long MAX_MACHINE_NUM = 7L;
    private static final long MACHINE_LEFT = 10L;
    private static final long TIMESTAMP_LEFT = 13L;
    private static final String MACHINE_ID_ENV = "MACHINE_ID";
    private long machineId;
    private long sequence = 0L;
    private long lastStamp = -1L;

    private SnowFlake() {
        try {
            String number = System.getenv().getOrDefault(MACHINE_ID_ENV, "0");
            this.init(Integer.parseInt(number));
        }
        catch (Exception e) {
            this.machineId = 0L;
        }
    }

    public static SnowFlake getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public static String decode(Long id) {
        long sequence = id & 0x3FFL;
        long machineId = id >> 10 & 7L;
        LocalDateTime dateTime = new Date((id >> 13) + 1613590487000L).toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        return Arrays.asList(dateTime, machineId, sequence).toString();
    }

    public void init(long machineId) {
        if (machineId > 7L || machineId < 0L) {
            throw new IllegalArgumentException("machineId can't be greater than MAX_MACHINE_NUM or less than 0");
        }
        this.machineId = machineId;
    }

    public synchronized long newId() {
        long currStamp = this.getNewStamp();
        if (currStamp < this.lastStamp) {
            throw new CommonException("Clock moved backwards. Refusing to generate id");
        }
        if (currStamp == this.lastStamp) {
            this.sequence = this.sequence + 1L & 0x3FFL;
            if (this.sequence == 0L) {
                currStamp = this.getNextMill();
            }
        } else {
            this.sequence = 0L;
        }
        this.lastStamp = currStamp;
        return currStamp - 1613590487000L << 13 | this.machineId << 10 | this.sequence;
    }

    private long getNextMill() {
        long mill = this.getNewStamp();
        while (mill <= this.lastStamp) {
            mill = this.getNewStamp();
        }
        return mill;
    }

    private long getNewStamp() {
        return System.currentTimeMillis();
    }

    private static class SingletonHolder {
        private static final SnowFlake INSTANCE = new SnowFlake();

        private SingletonHolder() {
        }
    }
}

