package com.digiwin.dap.middleware.commons.crypto.constant;

import java.util.Objects;

/**
 * 加密算法
 * <br>
 * <a href="https://docs.oracle.com/javase/7/docs/technotes/guides/security/StandardNames.html#KeyGenerator">对称算法类型</a>
 * <br>
 * <a href="https://docs.oracle.com/javase/7/docs/technotes/guides/security/StandardNames.html#KeyPairGenerator">非对称算法类型</a>
 *
 * @author michael
 */
public enum AlgorithmEnum {

    /**
     * 默认的AES加密方式：AES/ECB/PKCS5Padding
     */
    AES(true, "AES"),

    /**
     * RSA算法
     */
    RSA(false, "RSA"),
    ;

    /**
     * 是否对称算法标记，目前无实际用途
     */
    private final Boolean symmetry;
    private final String value;

    /**
     * 构造
     *
     * @param symmetry 对称算法
     * @param value    算法字符表示，区分大小写
     */
    AlgorithmEnum(Boolean symmetry, String value) {
        this.symmetry = symmetry;
        this.value = value;
    }

    public Boolean getSymmetry() {
        return symmetry;
    }

    /**
     * 获取算法字符串表示，区分大小写
     *
     * @return 算法字符串表示
     */
    public String getValue() {
        return this.value;
    }

    public static AlgorithmEnum getByValue(String value) {
        for (AlgorithmEnum algorithmEnum : AlgorithmEnum.values()) {
            if (Objects.equals(value, algorithmEnum.getValue())) {
                return algorithmEnum;
            }
        }
        return null;
    }

}
