package com.digiwin.dap.middleware.domain;

/**
 * 分页查询参数
 *
 * @author fobgochod
 * @since 1.0.8
 */
public class Page {

    /**
     * 页码，从1开始
     */
    private Integer pageNum;
    /**
     * 页面大小，默认10
     */
    private Integer pageSize;
    /**
     * 排序
     */
    private String orderBy;

    public Page() {
        this.pageNum = 1;
        this.pageSize = 10;
    }

    /**
     * 设置默认排序
     *
     * @param defaultOrderBy the default order by
     */
    public void setOrderByOrDefault(String defaultOrderBy) {
        if (this.orderBy == null || this.orderBy.isEmpty()) {
            this.orderBy = defaultOrderBy;
        }
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getOrderBy() {
        return orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public int skip() {
        return (this.pageNum - 1) * this.pageSize;
    }

    public int limit() {
        return this.pageSize;
    }
}
