package com.digiwin.dap.middleware.serializer;

import java.time.format.DateTimeFormatter;

/**
 * 日期格式话
 *
 * @author fobgochod
 */
public class Constants {

    private Constants() {
    }

    public static final String DATE_PATTERN = "yyyy-MM-dd";
    public static final String DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String TIME_PATTERN = "HH:mm:ss";
    public static final String PURE_DATETIME_PATTERN = "yyyyMMddHHmmss";

    public static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern(DATE_PATTERN);
    public static final DateTimeFormatter DATETIME_FORMATTER = DateTimeFormatter.ofPattern(DATETIME_PATTERN);
    public static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern(TIME_PATTERN);
    public static final DateTimeFormatter PURE_DATETIME_FORMATTER = DateTimeFormatter.ofPattern((PURE_DATETIME_PATTERN));
}
