/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.commons.crypto;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.crypto.SecureUtil;
import com.digiwin.dap.middleware.serializer.Constants;
import com.digiwin.dap.middleware.util.JsonUtils;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;

public class SignUtils {
    private static final String SIGN = "sign";
    private static final String AND = "&";
    private static final String EQUAL_SIGN = "=";

    private SignUtils() {
    }

    public static String sign(String key, String data) {
        return SecureUtil.hmacSha256((String)key).digestBase64(data, StandardCharsets.UTF_8, true);
    }

    @SafeVarargs
    public static String sign(Map<String, String> signParams, String key, Map<String, String> ... otherParams) {
        signParams.putIfAbsent("timestamp", LocalDateTime.now().format(Constants.PURE_DATETIME_FORMATTER));
        signParams.putIfAbsent("nonce", RandomUtil.randomString((int)16));
        String signParam = SignUtils.sortParam(signParams);
        Object[] params = new String[otherParams.length + 1];
        params[0] = signParam;
        for (int i = 0; i < otherParams.length; ++i) {
            params[i + 1] = SignUtils.sortParam(otherParams[i]);
        }
        LinkedList combineParams = ListUtil.toLinkedList((Object[])params);
        CollUtil.removeEmpty((Collection)combineParams);
        String signString = CollUtil.join((Iterable)combineParams, (CharSequence)AND);
        String sign = SignUtils.sign(key, signString);
        signParams.put(SIGN, sign);
        return sign;
    }

    @SafeVarargs
    public static boolean verify(Map<String, String> signParams, String key, Map<String, String> ... otherParams) {
        String oldSign = signParams.remove(SIGN);
        String signParam = SignUtils.sortParam(signParams);
        Object[] params = new String[otherParams.length + 1];
        params[0] = signParam;
        for (int i = 0; i < otherParams.length; ++i) {
            params[i + 1] = SignUtils.sortParam(otherParams[i]);
        }
        LinkedList combineParams = ListUtil.toLinkedList((Object[])params);
        CollUtil.removeEmpty((Collection)combineParams);
        String signString = CollUtil.join((Iterable)combineParams, (CharSequence)AND);
        String newSign = SignUtils.sign(key, signString);
        return Objects.equals(newSign, oldSign);
    }

    public static boolean verify(Map<String, String> signParams, String key, Map<String, String> queryParams, String bodyParam) {
        String oldSign = signParams.remove(SIGN);
        String signParam = SignUtils.sortParam(signParams);
        String queryParam = SignUtils.sortParam(queryParams);
        LinkedList combineParams = ListUtil.toLinkedList((Object[])new String[]{signParam, queryParam, bodyParam});
        CollUtil.removeEmpty((Collection)combineParams);
        String signString = CollUtil.join((Iterable)combineParams, (CharSequence)AND);
        String newSign = SignUtils.sign(key, signString);
        return Objects.equals(newSign, oldSign);
    }

    public static String sortParam(String json) {
        Map objectMap = JsonUtils.jsonToObj(json, Map.class);
        return SignUtils.sortParam(objectMap);
    }

    public static String sortParam(Object object) {
        Map<String, String> objectMap = JsonUtils.objToMap(object);
        return SignUtils.sortParam(objectMap);
    }

    public static String sortParam(Map<String, String> params) {
        return MapUtil.sortJoin(params, (String)AND, (String)EQUAL_SIGN, (boolean)true, (String[])new String[0]);
    }
}

