package com.digiwin.dap.middleware.constant;

import java.util.Arrays;

/**
 * 中间件所有Headers信息
 *
 * @author fobgochod
 * @since 1.0.8
 */
@SuppressWarnings("java:S115")
public enum DapHttpHeaders {

    /**
     * 内部调用标记
     */
    AUTH_ARG("digi-middleware-auth-arg"),
    /**
     * 用户token
     */
    USER_TOKEN("digi-middleware-auth-user"),
    /**
     * 应用token
     */
    APP_TOKEN("digi-middleware-auth-app"),
    /**
     * 授权码，包含租户、应用信息
     */
    SECRET_KEY("digi-middleware-auth-secret-key"),
    /**
     * 应用-密钥对信息
     */
    APP_ID("digi-middleware-auth-app-id"),
    APP_SECRET("digi-middleware-auth-app-secret"),
    APP_ARGS("digi-middleware-sign-arg"),
    /**
     * 服务商-密钥对信息
     */
    DEV_ID("digi-middleware-auth-isv-id"),
    DEV_SECRET("digi-middleware-auth-isv-secret"),
    DEV_ARGS("digi-middleware-auth-isv-sign-arg"),
    /**
     * Access
     */
    ACCESS_TOKEN("digi-middleware-auth-access"),
    /**
     * Ota
     */
    OTA_TOKEN("digi-middleware-auth-ota"),
    /**
     * 文档中心token
     */
    DRIVE_TOKEN("digi-middleware-drive-access"),
    /**
     * OAuth
     */
    OAUTH_ACCESS_TOKEN("digi-middleware-oauth-access"),
    /**
     * 邮件短信事件ID
     */
    MESSAGE_EVENT_ID("digi-middleware-event-id"),
    /**
     * AUTHORIZATION
     */
    AUTHORIZATION("authorization"),
    /**
     * 数据脱敏标识
     */
    DATA_MASK("digi-middleware-data-mask"),
    /**
     * 租户ID
     */
    TENANT_ID("tenantId"),
    /**
     * 访问设备
     */
    CLIENT_AGENT("Client-Agent"),
    /**
     * 客户端信息（移动端还是网页端）
     */
    CLIENT_AGENT_("digi-middleware-client-agent"),
    /**
     * 标准多语言
     */
    ACCEPT_LANGUAGE("Accept-Language"),
    /**
     * 多语言 兼容
     */
    LOCALE("Locale"),
    /**
     * 切换预发布标识
     */
    ROUTER_KEY("routerKey"),
    /**
     * 终端唯一标识，有中间件生成提供给客户端
     */
    DEVICE_ID("digi-middleware-device-id"),
    /**
     * 客户端设备唯一标识,用于生成终端唯一标识
     */
    M_DEVICE_ID("m-device-id"),
    /**
     * 客户端设备类型，用于生成终端唯一标识，web端不用填，移动端填具体设备类型，微信小程序填wechat，钉钉小程序填dingtalk
     */
    M_DEVICE_TYPE("m-device-type"),
    /**
     * 客户端来源，用于生成终端唯一标识，web端不用填，移动端填app，小程序填applet
     */
    M_SOURCE("m-source"),

    ;

    private final String header;

    DapHttpHeaders(String header) {
        this.header = header;
    }

    public static boolean contains(String header) {
        return Arrays.stream(values()).anyMatch(value -> value.header.equals(header));
    }

    public String getHeader() {
        return header;
    }
}
