/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.commons.util;

import com.digiwin.dap.middleware.exception.CommonException;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanUtils {
    private static final Logger logger = LoggerFactory.getLogger(BeanUtils.class);

    private BeanUtils() {
    }

    public static List<Field> getFields(Object object) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> aClass = object.getClass(); aClass != null; aClass = aClass.getSuperclass()) {
            Field[] declaredFields = aClass.getDeclaredFields();
            Arrays.stream(declaredFields).filter(field -> !field.isSynthetic() && !Modifier.isStatic(field.getModifiers())).forEach(fields::add);
        }
        return fields;
    }

    public static void mergeObject(Object origin, Object destination) {
        if (origin == null || destination == null) {
            return;
        }
        if (!origin.getClass().equals(destination.getClass())) {
            return;
        }
        List<Field> fieldList = BeanUtils.getFields(origin);
        for (Field field : fieldList) {
            field.setAccessible(true);
            try {
                Object value = field.get(origin);
                if (null != value) {
                    field.set(destination, value);
                }
                field.setAccessible(false);
            }
            catch (IllegalAccessException e) {
                throw new CommonException("\u5bf9\u8c61\u5408\u5e76\u9519\u8bef\uff01", e);
            }
        }
    }

    public static void mergeDifferentTypeObject(Object origin, Object destination) {
        if (origin == null || destination == null) {
            return;
        }
        List<Field> originFieldList = BeanUtils.getFields(origin);
        List<Field> destinationFieldList = BeanUtils.getFields(destination);
        for (Field origField : originFieldList) {
            for (Field destField : destinationFieldList) {
                if (!origField.getName().equals(destField.getName()) || origField.getAnnotation(JsonIgnore.class) != null) continue;
                BeanUtils.mergeField(origField, destField, origin, destination);
            }
        }
    }

    private static void mergeField(Field origField, Field destField, Object origin, Object destination) {
        try {
            origField.setAccessible(true);
            Object value = origField.get(origin);
            origField.setAccessible(false);
            if (value != null) {
                destField.setAccessible(true);
                destField.set(destination, value);
                destField.setAccessible(false);
            }
        }
        catch (IllegalAccessException e) {
            throw new CommonException("\u5bf9\u8c61\u590d\u5236\u9519\u8bef", e);
        }
    }

    public static Method getDeclaredMethod(Object object, String methodName, Class<?> ... parameterTypes) {
        Method method = null;
        for (Class<?> clazz = object.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                method = clazz.getDeclaredMethod(methodName, parameterTypes);
                return method;
            }
            catch (NoSuchMethodException | SecurityException e) {
                logger.error(e.getMessage(), (Throwable)e);
                continue;
            }
        }
        return null;
    }

    public static Object invokeMethod(Object object, String methodName, Class<?>[] parameterTypes, Object[] parameters) {
        Method method = BeanUtils.getDeclaredMethod(object, methodName, parameterTypes);
        try {
            if (method != null) {
                method.setAccessible(true);
                return method.invoke(object, parameters);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static List<Field> getDeclaredFields(Class<?> clazz) {
        ArrayList<Field> result = new ArrayList<Field>();
        Field[] fields = clazz.getDeclaredFields();
        Collections.addAll(result, fields);
        Class<?> superClass = clazz.getSuperclass();
        if (superClass == Object.class) {
            return result;
        }
        List<Field> superFields = BeanUtils.getDeclaredFields(superClass);
        result.addAll(superFields);
        return result;
    }

    public static Field getDeclaredField(Class<?> clazz, String fieldName) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            return field;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Class<?> superClass = clazz.getSuperclass();
            if (superClass == Object.class) {
                return null;
            }
            try {
                Field field = BeanUtils.getDeclaredField(superClass, fieldName);
                if (field != null) {
                    return field;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    public static void setFieldValue(Object object, String fieldName, Object value) {
        try {
            Field field = BeanUtils.getDeclaredField(object.getClass(), fieldName);
            if (field != null) {
                field.setAccessible(true);
                field.set(object, value);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static Object getFieldValue(Object object, String fieldName) {
        try {
            Field field = BeanUtils.getDeclaredField(object.getClass(), fieldName);
            if (field != null) {
                field.setAccessible(true);
                return field.get(object);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static <T> List<T> castEntity(List<Object[]> list, Class<T> clazz, Object model) {
        ArrayList<T> returnList = new ArrayList<T>();
        if (list.isEmpty()) {
            return returnList;
        }
        Object[] co = list.get(0);
        List<Map<String, Object>> attributeInfoList = BeanUtils.getFieldsInfo(model);
        Class[] c2 = new Class[attributeInfoList.size()];
        if (attributeInfoList.size() != co.length) {
            return returnList;
        }
        for (int i = 0; i < attributeInfoList.size(); ++i) {
            c2[i] = (Class)attributeInfoList.get(i).get("type");
        }
        try {
            for (Object[] o : list) {
                Constructor<T> constructor = clazz.getConstructor(c2);
                returnList.add(constructor.newInstance(o));
            }
        }
        catch (Exception ex) {
            logger.error("\u5b9e\u4f53\u6570\u636e\u8f6c\u5316\u4e3a\u5b9e\u4f53\u7c7b\u53d1\u751f\u5f02\u5e38\uff1a\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)ex.getMessage());
            return returnList;
        }
        return returnList;
    }

    private static Object getFieldValueByName(String fieldName, Object modle) {
        try {
            String firstLetter = fieldName.substring(0, 1).toUpperCase();
            String getter = "get" + firstLetter + fieldName.substring(1);
            Method method = modle.getClass().getMethod(getter, new Class[0]);
            return method.invoke(modle, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static List<Map<String, Object>> getFieldsInfo(Object model) {
        Field[] fields = model.getClass().getDeclaredFields();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(fields.length);
        for (Field field : fields) {
            HashMap<String, Object> infoMap = new HashMap<String, Object>(3);
            infoMap.put("type", field.getType());
            infoMap.put("name", field.getName());
            infoMap.put("value", BeanUtils.getFieldValueByName(field.getName(), model));
            list.add(infoMap);
        }
        return list;
    }
}

