/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.util;

import com.digiwin.dap.middleware.exception.CommonException;
import com.digiwin.dap.middleware.serializer.LocalDateDeserializer;
import com.digiwin.dap.middleware.serializer.LocalDateSerializer;
import com.digiwin.dap.middleware.serializer.LocalDateTimeDeserializer;
import com.digiwin.dap.middleware.serializer.LocalDateTimeSerializer;
import com.digiwin.dap.middleware.serializer.LocalTimeDeserializer;
import com.digiwin.dap.middleware.serializer.LocalTimeSerializer;
import com.digiwin.dap.middleware.serializer.SerializerUtil;
import com.digiwin.dap.middleware.serializer.TimestampDeserializer;
import com.digiwin.dap.middleware.serializer.TimestampSerializer;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collections;
import java.util.Map;

public final class JsonUtils {
    private static volatile ObjectMapper objectMapper = null;
    private static volatile ObjectMapper dmcObjectMapper = null;
    private static volatile ObjectMapper redisObjectMapper = null;

    private JsonUtils() {
    }

    public static <T> Map<String, String> objToMap(T obj) {
        try {
            String json = objectMapper.writeValueAsString(obj);
            return (Map)objectMapper.readValue(json, (TypeReference)new TypeReference<Map<String, String>>(){});
        }
        catch (Exception e) {
            throw new CommonException(e.getMessage(), e);
        }
    }

    public static <T> Map<String, Object> objToMapObject(T obj) {
        try {
            String json = objectMapper.writeValueAsString(obj);
            return (Map)objectMapper.readValue(json, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (Exception e) {
            throw new CommonException(e.getMessage(), e);
        }
    }

    public static <T> Map<String, String> writeToMap(T obj) {
        try {
            String json = objectMapper.writeValueAsString(obj);
            return (Map)objectMapper.readValue(json, (TypeReference)new TypeReference<Map<String, String>>(){});
        }
        catch (Exception exception) {
            return Collections.emptyMap();
        }
    }

    public static <T> Map<String, Object> writeToMapObject(T obj) {
        try {
            String json = objectMapper.writeValueAsString(obj);
            return (Map)objectMapper.readValue(json, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (Exception exception) {
            return Collections.emptyMap();
        }
    }

    public static <T> String objToJson(T obj) {
        String result;
        try {
            result = objectMapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            throw new CommonException(e.getMessage(), e);
        }
        return result;
    }

    public static <T> String writeValue(T obj) {
        try {
            return objectMapper.writeValueAsString(obj);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static <T> T jsonToObj(String json, Class<T> classType) {
        Object t;
        try {
            t = objectMapper.readValue(json, classType);
        }
        catch (Exception e) {
            throw new CommonException(e.getMessage(), e);
        }
        return (T)t;
    }

    public static <T> T jsonToObj(String json, TypeReference<T> valueTypeRef) {
        Object t;
        try {
            t = objectMapper.readValue(json, valueTypeRef);
        }
        catch (Exception e) {
            throw new CommonException(e.getMessage(), e);
        }
        return (T)t;
    }

    public static <T> T jsonToObj(InputStream json, Class<T> classType) {
        Object t;
        try {
            t = objectMapper.readValue(json, classType);
        }
        catch (Exception e) {
            throw new CommonException(e.getMessage(), e);
        }
        return (T)t;
    }

    public static <T> T jsonToObj(InputStream json, TypeReference<T> valueTypeRef) {
        Object t;
        try {
            t = objectMapper.readValue(json, valueTypeRef);
        }
        catch (Exception e) {
            throw new CommonException(e.getMessage(), e);
        }
        return (T)t;
    }

    public static <T> T readValue(String json, Class<T> classType) {
        try {
            return (T)objectMapper.readValue(json, classType);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static <T> T readValue(String json, TypeReference<T> valueTypeRef) {
        try {
            return (T)objectMapper.readValue(json, valueTypeRef);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static <T> T readValue(InputStream json, Class<T> valueType) {
        try {
            return (T)objectMapper.readValue(json, valueType);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static <T> T readValue(InputStream json, TypeReference<T> valueTypeRef) {
        try {
            return (T)objectMapper.readValue(json, valueTypeRef);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static <T> T convertObj(Object fromObj, Class<T> toObjType) {
        Object t;
        try {
            t = objectMapper.convertValue(fromObj, toObjType);
        }
        catch (Exception e) {
            throw new CommonException(e.getMessage(), e);
        }
        return (T)t;
    }

    public static <T> T convertValue(Object fromObj, Class<T> toObjType) {
        try {
            return (T)objectMapper.convertValue(fromObj, toObjType);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ObjectMapper createObjectMapper() {
        if (objectMapper != null) return objectMapper;
        Class<JsonUtils> clazz = JsonUtils.class;
        synchronized (JsonUtils.class) {
            if (objectMapper != null) return objectMapper;
            objectMapper = JsonUtils.getObjectMapper(1);
            // ** MonitorExit[var0] (shouldn't be in output)
            return objectMapper;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ObjectMapper createDmcObjectMapper() {
        if (dmcObjectMapper != null) return dmcObjectMapper;
        Class<JsonUtils> clazz = JsonUtils.class;
        synchronized (JsonUtils.class) {
            if (dmcObjectMapper != null) return dmcObjectMapper;
            dmcObjectMapper = JsonUtils.getObjectMapper(2);
            // ** MonitorExit[var0] (shouldn't be in output)
            return dmcObjectMapper;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ObjectMapper createRedisObjectMapper() {
        if (redisObjectMapper != null) return redisObjectMapper;
        Class<JsonUtils> clazz = JsonUtils.class;
        synchronized (JsonUtils.class) {
            if (redisObjectMapper != null) return redisObjectMapper;
            redisObjectMapper = JsonUtils.getObjectMapper(3);
            // ** MonitorExit[var0] (shouldn't be in output)
            return redisObjectMapper;
        }
    }

    private static ObjectMapper getObjectMapper(int type) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)JsonUtils.getJavaTimeModule());
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, Boolean.FALSE.booleanValue());
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, Boolean.FALSE.booleanValue());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.enable(new JsonParser.Feature[]{JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS.mappedFeature()});
        objectMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        if (type == 1) {
            objectMapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        } else if (type == 3) {
            objectMapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
            objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
            objectMapper.activateDefaultTyping(objectMapper.getPolymorphicTypeValidator(), ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.PROPERTY);
        }
        return objectMapper;
    }

    private static JavaTimeModule getJavaTimeModule() {
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer());
        javaTimeModule.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer());
        javaTimeModule.addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializer());
        javaTimeModule.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer());
        javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer());
        javaTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer());
        javaTimeModule.addSerializer(Timestamp.class, (JsonSerializer)new TimestampSerializer());
        javaTimeModule.addDeserializer(Timestamp.class, (JsonDeserializer)new TimestampDeserializer());
        SerializerUtil.addSerializer(javaTimeModule);
        return javaTimeModule;
    }

    static {
        JsonUtils.createObjectMapper();
    }
}

