package com.digiwin.dap.middleware.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;

public class UTCDateTimeSerializer extends JsonSerializer<LocalDateTime> {

    /**
     * 将当前系统时区时间变成UTC时间
     * 如时区：Asia/Shanghai，时间：2020-04-14 09:00:00
     * 则返回：2020-04-14 01:00:00
     */
    @Override
    public void serialize(LocalDateTime value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        LocalDateTime localDateTime = value.atZone(ZoneId.systemDefault()).withZoneSameInstant(ZoneOffset.UTC).toLocalDateTime();
        gen.writeString(localDateTime.toString());
    }
}
