/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.commons.util;

import com.digiwin.dap.middleware.util.JsonUtils;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.StringWriter;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreemarkerUtils {
    private static final Logger logger = LoggerFactory.getLogger(FreemarkerUtils.class);
    private static final Configuration configuration = new Configuration(Configuration.VERSION_2_3_20);

    private FreemarkerUtils() {
    }

    public static String processFile(String fileName, Object param) {
        try {
            Template template = configuration.getTemplate(fileName);
            StringWriter sw = new StringWriter();
            template.process(param, (Writer)sw);
            return sw.toString();
        }
        catch (Exception e) {
            logger.error("\u3010freemarker\u3011 \u6a21\u677f\u5904\u7406\u5f02\u5e38, fileName:{},param:{}", new Object[]{fileName, JsonUtils.objToJson(param), e});
            return null;
        }
    }

    public static String processString(String s, Object param) {
        try {
            StringWriter result = new StringWriter();
            Template template = new Template("strTpl", s, new Configuration(Configuration.VERSION_2_3_23));
            template.process(param, (Writer)result);
            return result.toString();
        }
        catch (Exception e) {
            logger.error("\u3010freemarker\u3011 \u6a21\u677f\u5904\u7406\u5f02\u5e38, \u5b57\u7b26\u4e32:{},param:{}", new Object[]{s, JsonUtils.objToJson(param), e});
            return null;
        }
    }

    static {
        configuration.setClassForTemplateLoading(FreemarkerUtils.class, "/static/templates");
        configuration.setDefaultEncoding("utf-8");
    }
}

