package com.digiwin.dap.middleware.commons.core.codec;

import com.digiwin.dap.middleware.commons.util.StrUtils;

import static java.util.Base64.getDecoder;
import static java.util.Base64.getEncoder;

/**
 * Base64工具类，提供Base64的编码和解码方案<br>
 * base64编码是用64（2的6次方）个ASCII字符来表示256（2的8次方）个ASCII字符，<br>
 * 也就是三位二进制数组经过编码后变为四位的ASCII字符显示，长度比原来增加1/3。
 *
 * @author fobgochod
 * @since 1.0.0
 */
public class Base64 {

    public static String encode(String src) {
        return encode(StrUtils.bytes(src));
    }

    public static String encode(byte[] src) {
        return StrUtils.str(getEncoder().encode(src));
    }

    public static byte[] decode(String src) {
        return decode(StrUtils.bytes(src));
    }

    public static byte[] decode(byte[] src) {
        return getDecoder().decode(src);
    }
}
