package com.digiwin.dap.middleware.commons.crypto;

import cn.hutool.crypto.digest.DigestUtil;
import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.digiwin.dap.middleware.commons.core.codec.Base64;
import com.digiwin.dap.middleware.commons.crypto.constant.KeyConstant;
import com.digiwin.dap.middleware.commons.util.StrUtils;

/**
 * 摘要算法工具类
 *
 * @author fobgochod
 * @since 1.0.0
 */
public class DigestUtils {

    /**
     * 计算sha256摘要值
     *
     * @param data 被摘要数据
     * @return SHA-256摘要
     */
    public static String sha256(String data) {
        return sha256(data, 2);
    }

    /**
     * 计算sha256摘要值
     *
     * @param data  被摘要数据
     * @param count 摘要计算次数
     * @return SHA-256摘要
     */
    public static String sha256(String data, int count) {
        byte[] digest = StrUtils.bytes(data);
        for (int i = 0; i < count; i++) {
            digest = DigestUtil.sha256(digest);
        }
        return Base64.encode(digest);
    }

    /**
     * 计算32位MD5摘要值，并转为16进制字符串
     *
     * @param data 被摘要数据
     * @return md5摘要
     */
    public static String md5Hex(String data) {
        return DigestUtil.md5Hex(StrUtils.bytes(data));
    }

    /**
     * 根据应用id去创建token信息
     * 保证每一区的token一致
     *
     * @param sysId 应用ID
     * @return appToken
     * @since 1.0.2
     */
    public static String getAppToken(String sysId) {
        try {
            Algorithm algorithm = Algorithm.HMAC256(KeyConstant.OTHER);
            return JWT.create()
                    .withClaim("id", sysId)
                    .withClaim("sid", 0L)
                    .sign(algorithm);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}
