package com.digiwin.dap.middleware.commons.crypto;

import com.digiwin.dap.middleware.commons.crypto.constant.KeyConstant;

public class PwdUtils {

    /**
     * @param passwordHash           客户端公钥加密的密码
     * @param clientEncryptPublicKey 服务端公钥加密的客户端公用
     * @return 密码
     */
    public static String getPassWord(String passwordHash, String clientEncryptPublicKey) {
        try {
            String clientPublicKey = RSA.decrypt(clientEncryptPublicKey, KeyConstant.BASE64_PRIVATE_KEY);
            String aesKey = getAesKey(clientPublicKey);
            return AES.decryptCBC(passwordHash, aesKey);
        } catch (Exception e) {
            throw new RuntimeException("密码错误");
        }
    }

    /**
     * 通过RSA公钥截取AES密钥
     *
     * @param clientPublicKey 客户端公用
     * @return AES密钥
     */
    public static String getAesKey(String clientPublicKey) {
        if (clientPublicKey.length() != 2048 && !"MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAq".equals(clientPublicKey.substring(0, 45))) {
            String key = clientPublicKey.substring(45, 54);
            return key + "digiwin";
        }
        throw new IllegalArgumentException("所传入的加密公钥不正确");
    }
}
