package com.digiwin.dap.middleware.iam.util;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.digiwin.dap.middleware.commons.crypto.AES;
import com.digiwin.dap.middleware.commons.crypto.DigestUtils;
import com.digiwin.dap.middleware.commons.crypto.constant.KeyConstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Base64.Decoder;
import java.util.Base64.Encoder;

/**
 * 建议使用com.digiwin.dap.middleware.util.SecureUtils
 */
@Deprecated
public class AESCipher {

    private static final Logger log = LoggerFactory.getLogger(AESCipher.class);

    /**
     * AES加密
     *
     * @param content 被加密内容
     * @return 加密后内容
     * @deprecated {@link AES#encryptCBC(String, String)}
     */
    public static String aesEncryptString(String content) {
        byte[] contentBytes;
        try {
            contentBytes = content.getBytes(StandardCharsets.UTF_8);
            byte[] keyBytes = KeyConstant.OTHER.getBytes(StandardCharsets.UTF_8);
            byte[] encryptedBytes = aesEncryptBytes(contentBytes, keyBytes);
            Encoder encoder = Base64.getEncoder();
            return encoder.encodeToString(encryptedBytes);
        } catch (Exception e) {
            log.info("加密错误", e);
            throw new RuntimeException(e);
        }
    }

    /**
     * AES解密
     *
     * @param content 加密内容
     * @return 解密后内容
     * @deprecated {@link AES#decryptCBC(String, String)}
     */
    public static String aesDecryptString(String content) {
        try {
            Decoder decoder = Base64.getDecoder();
            byte[] encryptedBytes = decoder.decode(content);
            byte[] keyBytes = KeyConstant.OTHER.getBytes(StandardCharsets.UTF_8);
            byte[] decryptedBytes = aesDecryptBytes(encryptedBytes, keyBytes);
            return new String(decryptedBytes, StandardCharsets.UTF_8);
        } catch (Exception e) {
            log.info("解密错误", e);
            throw new RuntimeException(e);
        }
    }

    /**
     * 根据应用id去创建token信息
     * 保证每一区的token一致
     *
     * @param sysId 应用ID
     * @return appToken
     * @deprecated {@link DigestUtils#getAppToken(String)}
     */
    public static String getAppToken(String sysId) {
        try {
            Algorithm algorithm = Algorithm.HMAC256(KeyConstant.OTHER);
            return JWT.create()
                    .withClaim("id", sysId)
                    .withClaim("sid", 0L)
                    .sign(algorithm);
        } catch (Exception e) {
            log.error("加密错误", e);
            throw new RuntimeException(e);
        }
    }

    private static byte[] aesEncryptBytes(byte[] contentBytes, byte[] keyBytes) throws Exception {
        return cipherOperation(contentBytes, keyBytes, Cipher.ENCRYPT_MODE);
    }

    private static byte[] aesDecryptBytes(byte[] contentBytes, byte[] keyBytes) throws Exception {
        return cipherOperation(contentBytes, keyBytes, Cipher.DECRYPT_MODE);
    }

    private static byte[] cipherOperation(byte[] contentBytes, byte[] keyBytes, int mode) throws Exception {
        SecretKeySpec secretKey = new SecretKeySpec(keyBytes, "AES");

        IvParameterSpec ivParameterSpec = new IvParameterSpec(KeyConstant.IV);

        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(mode, secretKey, ivParameterSpec);

        return cipher.doFinal(contentBytes);
    }

    public static String getAppSecret(long tenantSid, String appId) {
        String content = String.format("%s_@#$_%s_%s", appId, tenantSid, System.currentTimeMillis());
        return AESCipher.aesEncryptString(content);
    }
}
