package com.digiwin.dap.middleware.iam.util;

import com.digiwin.dap.middleware.commons.crypto.AES;
import com.digiwin.dap.middleware.commons.crypto.constant.KeyConstant;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

/**
 * 建议使用com.digiwin.dap.middleware.util.SecureUtils
 */
public class AESUtils {

    private static final Logger logger = LoggerFactory.getLogger(AESUtils.class);

    public static String aesEncryptString(String content, String clientPublicKey) {
        byte[] contentBytes;
        try {
            contentBytes = content.getBytes(StandardCharsets.UTF_8);
            byte[] keyBytes = getAesKey(clientPublicKey).getBytes(StandardCharsets.UTF_8);
            byte[] encryptedBytes = aesEncryptBytes(contentBytes, keyBytes);
            Base64.Encoder encoder = Base64.getEncoder();
            return encoder.encodeToString(encryptedBytes);
        } catch (Exception e) {
            throw new RuntimeException("加密错误：" + e.getMessage(), e);
        }
    }

    public static String aesDecryptString(String content, String clientPublicKey) {
        try {
            Base64.Decoder decoder = Base64.getDecoder();
            byte[] encryptedBytes = decoder.decode(content);
            byte[] keyBytes = getAesKey(clientPublicKey).getBytes(StandardCharsets.UTF_8);
            byte[] decryptedBytes = aesDecryptBytes(encryptedBytes, keyBytes);
            return new String(decryptedBytes, StandardCharsets.UTF_8);
        } catch (Exception e) {
            throw new RuntimeException("解密错误：" + e.getMessage(), e);
        }
    }

    private static byte[] aesEncryptBytes(byte[] contentBytes, byte[] keyBytes) throws Exception {
        return cipherOperation(contentBytes, keyBytes, Cipher.ENCRYPT_MODE);
    }

    private static byte[] aesDecryptBytes(byte[] contentBytes, byte[] keyBytes) throws Exception {
        return cipherOperation(contentBytes, keyBytes, Cipher.DECRYPT_MODE);
    }

    private static byte[] cipherOperation(byte[] contentBytes, byte[] keyBytes, int mode) throws Exception {
        SecretKeySpec secretKey = new SecretKeySpec(keyBytes, "AES");

        IvParameterSpec ivParameterSpec = new IvParameterSpec(KeyConstant.IV);

        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(mode, secretKey, ivParameterSpec);

        return cipher.doFinal(contentBytes);
    }

    public static String getAesKey(String clientPublicKey) {
        if (clientPublicKey.length() != 2048 && !"MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAq".equals(clientPublicKey.substring(0, 45))) {
            String key = clientPublicKey.substring(45, 54);
            return key + "digiwin";
        }
        throw new IllegalArgumentException("所传入的加密公钥不正确");
    }

    /**
     * 加密
     * 加密失败返回原文 2021-7-21
     * <p>
     *
     * @param src    加密字段
     * @param aesKey aesKey
     * @return 密文 .toUpperCase() 和MySQL保持一致
     * @deprecated {@link AES#encryptHex(String, String)}
     */
    public static String aesEncrypt(String src, String aesKey) {
        try {
            // 生成和mysql一致的加密数据
            SecretKeySpec key = generateMySQLAESKey(aesKey);
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(Cipher.ENCRYPT_MODE, key);

            byte[] cleartext = src.getBytes(StandardCharsets.UTF_8);
            byte[] ciphertextBytes = cipher.doFinal(cleartext);
            return new String(Hex.encodeHexString(ciphertextBytes)).toUpperCase();
        } catch (Exception ex) {
            logger.error("AES加密失败[{}]", src);
            return src;
        }
    }

    /**
     * 解密
     * 解密失败返回原文 2021-7-21
     * <p>
     *
     * @param content 密文
     * @param aesKey  aesKey
     * @return 原文
     * @deprecated {@link AES#decryptHex(String, String)}  }
     */
    public static String aesDecrypt(String content, String aesKey) {
        try {
            SecretKey key = generateMySQLAESKey(aesKey);
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(Cipher.DECRYPT_MODE, key);
            byte[] cleartext = Hex.decodeHex(content.toCharArray());
            byte[] ciphertextBytes = cipher.doFinal(cleartext);
            return new String(ciphertextBytes, StandardCharsets.UTF_8);
        } catch (Exception ex) {
            logger.error("解密异常", ex);
            throw new RuntimeException(ex);
        }
    }

    public static SecretKeySpec generateMySQLAESKey(final String key) {
        final byte[] finalKey = new byte[16];
        int i = 0;
        for (byte b : key.getBytes(StandardCharsets.UTF_8)) {
            finalKey[i++ % 16] ^= b;
        }
        return new SecretKeySpec(finalKey, "AES");
    }

    /**
     * AES加密
     * 加密失败返回原文 2021-7-21
     *
     * @param src 加密信息
     * @return 密文
     */
    public static String aesEncrypt(String src) {
        return src == null ? null : aesEncrypt(src, KeyConstant.DIGIWIN);
    }

    /**
     * AES解密
     * 解密失败返回原文 2021-7-21
     *
     * @param src 被加密信息
     * @return 明文
     */
    public static String aesDecrypt(String src) {
        try {
            return src == null ? null : aesDecrypt(src, KeyConstant.DIGIWIN);
        } catch (Exception e) {
            logger.error("AES解密失败[{}]", src);
            return src;
        }
    }


    public static String encryptTempUserToken(String secretKey, String content) {
        try {
            // 秘钥
            byte[] enCodeFormat = hex2byte(secretKey);
            // 创建AES秘钥
            SecretKeySpec key = new SecretKeySpec(enCodeFormat, "AES");
            // 创建密码器
            Cipher cipher = Cipher.getInstance("AES");
            // 初始化加密器
            cipher.init(Cipher.ENCRYPT_MODE, key);
            // 加密
            byte[] bytes = cipher.doFinal(content.getBytes(StandardCharsets.UTF_8));
            // 10.将加密后的数据转换为字符串
            return byte2hex(bytes);
        } catch (Exception e) {
            logger.error("加密错误", e);
            throw new RuntimeException(e);
        }
    }


    public static String decryptTempUserToken(String secretKey, String content) throws Exception {
        if (content == null || content.length() < 2) {
            return content;
        }
        // 秘钥
        byte[] enCodeFormat = hex2byte(secretKey);
        // 创建AES秘钥
        SecretKeySpec key = new SecretKeySpec(enCodeFormat, "AES");
        // 创建密码器
        Cipher cipher = Cipher.getInstance("AES");
        // 初始化解密器
        cipher.init(Cipher.DECRYPT_MODE, key);
        // 解密
        byte[] result = cipher.doFinal(hex2byte(content));
        return new String(result, StandardCharsets.UTF_8);
    }

    private static String byte2hex(byte[] b) {
        StringBuilder sb = new StringBuilder(b.length * 2);
        String tmp = "";
        for (byte aB : b) {
            // 整数转成十六进制表示
            tmp = (Integer.toHexString(aB & 0XFF));
            if (tmp.length() == 1) {
                sb.append("0");
            }
            sb.append(tmp);
        }
        return sb.toString().toUpperCase(); // 转成大写
    }

    private static byte[] hex2byte(String inputString) {
        if (inputString == null || inputString.length() < 2) {
            return new byte[0];
        }
        inputString = inputString.toLowerCase();
        int l = inputString.length() / 2;
        byte[] result = new byte[l];
        for (int i = 0; i < l; ++i) {
            String tmp = inputString.substring(2 * i, 2 * i + 2);
            result[i] = (byte) (Integer.parseInt(tmp, 16) & 0xFF);
        }
        return result;
    }
}
