package com.digiwin.dap.middleware.util;

import com.digiwin.dap.middleware.commons.core.codec.Base64;
import com.digiwin.dap.middleware.commons.crypto.AES;
import com.digiwin.dap.middleware.commons.crypto.constant.KeyConstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;

@Deprecated
public class SecureUtils {

    public static final String CHANGE_PASSWORD_AES_KEY = Base64.encode(KeyConstant.WECHAT_UNION_ID);
    private static final Logger logger = LoggerFactory.getLogger(SecureUtils.class);
    private static final String AES_SECRET_KEY = Base64.encode(KeyConstant.CONSOLE);
    private static final int ivSize = 16;

    public static String encrypt(String data, String secretKey) {
        return AES.encrypt(data, secretKey);
    }

    public static String decrypt(String data, String secretKey) {
        return AES.decrypt(data, secretKey);
    }

    public static String aesEncrypt(String data) {
        return aesEncrypt(data, AES_SECRET_KEY);
    }

    public static String aesDecrypt(String data) {
        return aesDecrypt(data, AES_SECRET_KEY);
    }

    public static String aesEncrypt(String data, String base64SecretKey) {
        byte[] secretKey = Base64.decode(base64SecretKey);
        return AES.encrypt(data, secretKey);
    }

    public static String aesDecrypt(String data, String base64SecretKey) {
        byte[] secretKey = Base64.decode(base64SecretKey);
        return AES.decrypt(data, secretKey);
    }

    public static String aesEncryptHex(String data, String secretKey) {
        return AES.encryptHex(data, secretKey);
    }

    public static String aesDecryptHex(String data, String secretKey) {
        return AES.decryptHex(data, secretKey);
    }

    /**
     * 加密
     *
     * <p>
     * 模式： "AES/CBC/PKCS5Padding"
     * <p>
     * 说明：
     *  <ul>
     *     <li>1.CBC引入了初始向量比ECB模式更安全，块之间有关联性，同明文不同上下文，密文不相同</li>
     *     <li>2.使用 16 位随机数组作为 IV 初始向量，随机码数组拼接在密文的前16位，同明文的密文每次都会变化</li>
     *     <li>3.加密后转为base64字符串，比Hex更少的字符，更适用于网络传输</li>
     *     <li>4.对不规范长度的密钥key自动补位</li>
     * </ul>
     *
     * @param content 明文
     * @param key     AES密钥长度128位(支持A128/192/256)，密钥会自动补全16字符串(128位)
     * @return Base64 string
     * @deprecated {@link AES#encryptIvCBC(String, String)}
     */
    public static String encryptBase64(String content, String key) {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");

            byte[] iv = new byte[ivSize];
            SecureRandom random = new SecureRandom();
            random.nextBytes(iv);
            IvParameterSpec ivParams = new IvParameterSpec(iv);

            SecretKeySpec secretKeySpec = new SecretKeySpec(AES.paddingKey(key), "AES");
            cipher.init(Cipher.ENCRYPT_MODE, secretKeySpec, ivParams);

            byte[] encryptedText = cipher.doFinal(content.getBytes(StandardCharsets.UTF_8));
            byte[] ivAndEncryptedText = new byte[ivSize + encryptedText.length];

            System.arraycopy(iv, 0, ivAndEncryptedText, 0, ivSize);
            System.arraycopy(encryptedText, 0, ivAndEncryptedText, ivSize, encryptedText.length);
            return Base64.encode(ivAndEncryptedText);
        } catch (Exception e) {
            throw new RuntimeException("加密异常，aes content=" + content, e);
        }
    }

    /**
     * 解密
     *
     * @param content 被解密内容
     * @param key     密钥
     * @return 明文
     * @deprecated {@link AES#decryptIvCBC(String, String)}
     */
    public static String decryptBase64(String content, String key) {
        try {
            byte[] ivAndEncryptedText = Base64.decode(content.getBytes());

            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");

            IvParameterSpec ivParameterSpec = new IvParameterSpec(ivAndEncryptedText, 0, ivSize);

            SecretKeySpec secretKeySpec = new SecretKeySpec(AES.paddingKey(key), "AES");
            cipher.init(Cipher.DECRYPT_MODE, secretKeySpec, ivParameterSpec);

            byte[] contentBytes = cipher.doFinal(ivAndEncryptedText, ivSize, ivAndEncryptedText.length - ivSize);
            return new String(contentBytes, StandardCharsets.UTF_8);
        } catch (Exception e) {
            throw new RuntimeException("解密异常，aes content=" + content, e);
        }
    }
}
