package com.digiwin.dap.middleware.commons.core.codec;

import com.digiwin.dap.middleware.exception.CommonException;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

import static java.nio.charset.StandardCharsets.ISO_8859_1;
import static java.nio.charset.StandardCharsets.UTF_8;

/**
 * URL工具类
 *
 * @author fobgochod
 * @since 1.0.8
 */
public class URL {

    private URL() {
    }

    /**
     * URL Encode
     *
     * @param data 要编码的字符串
     * @return 编码结果
     */
    public static String encode(String data) {
        try {
            return URLEncoder.encode(data, UTF_8.name());
        } catch (UnsupportedEncodingException e) {
            throw new CommonException(e);
        }
    }

    /**
     * URL  Decode
     *
     * @param data 要解码的字符串
     * @return 解码结果
     */
    public static String decode(String data) {
        String parsed = new String(data.getBytes(ISO_8859_1), UTF_8);
        try {
            return URLDecoder.decode(parsed, UTF_8.name());
        } catch (UnsupportedEncodingException e) {
            throw new CommonException(e);
        }
    }
}
