package com.digiwin.dap.middleware.serializer;

import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import org.bson.types.ObjectId;

/**
 * 添加Mongo ID序列化
 *
 * @author fobgochod
 * @since 1.0.0
 */
public class SerializerUtil {

    private SerializerUtil() {
    }

    public static void addSerializer(JavaTimeModule javaTimeModule) {
        try {
            javaTimeModule.addSerializer(ObjectId.class, new ObjectIdSerializer());
            javaTimeModule.addDeserializer(ObjectId.class, new ObjectIdDeserializer());
        } catch (NoClassDefFoundError ignored) {
            // Exception ignored intentionally
        }
    }
}
