/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.commons.crypto;

import cn.hutool.core.util.HexUtil;
import cn.hutool.crypto.SecureUtil;
import com.digiwin.dap.middleware.commons.crypto.AES;
import com.digiwin.dap.middleware.commons.crypto.RSA;
import com.digiwin.dap.middleware.commons.util.StrUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PwdUtils {
    private static final Logger logger = LoggerFactory.getLogger(PwdUtils.class);

    private PwdUtils() {
    }

    public static String getPassWord(String passwordHash, String clientEncryptPublicKey, String privateKey) {
        String clientPublicKey = RSA.decrypt(clientEncryptPublicKey, privateKey);
        return PwdUtils.decryptPwd(passwordHash, clientPublicKey);
    }

    public static String encryptPwd(String data, String clientPublicKey) {
        String aesKey = PwdUtils.getAesKey(clientPublicKey);
        return AES.encryptCBC(data, aesKey);
    }

    public static String decryptPwd(String data, String clientPublicKey) {
        String aesKey = PwdUtils.getAesKey(clientPublicKey);
        return AES.decryptCBC(data, aesKey);
    }

    public static String encryptHex(String data, String key) {
        try {
            return StrUtils.isEmpty(data) ? data : AES.encryptHex(data, key);
        }
        catch (Exception e) {
            logger.error("AES\u52a0\u5bc6\u5931\u8d25[{}]", (Object)data, (Object)e);
            return data;
        }
    }

    public static String decryptHex(String data, String key) {
        try {
            return StrUtils.isEmpty(data) ? data : AES.decryptHex(data, key);
        }
        catch (Exception e) {
            logger.error("AES\u89e3\u5bc6\u5931\u8d25[{}]", (Object)data, (Object)e);
            return data;
        }
    }

    public static String encodeHex(String data, String key) {
        byte[] aesKey = HexUtil.decodeHex((String)key);
        byte[] bytes = SecureUtil.aes((byte[])aesKey).encrypt(data);
        return HexUtil.encodeHexStr((byte[])bytes, (boolean)false);
    }

    public static String decodeHex(String data, String key) {
        byte[] aesKey = HexUtil.decodeHex((String)key);
        byte[] bytes = SecureUtil.aes((byte[])aesKey).decrypt(data);
        return StrUtils.str(bytes);
    }

    public static String getAesKey(String clientPublicKey) {
        String key = clientPublicKey.substring(45, 54);
        return key + "digiwin";
    }
}

